-- =============================================
-- SaveToDB Framework for NuoDB
-- Version 8.15, November 7, 2018
--
-- This script upgrades SaveToDB Framework 8.11 to SaveToDB Framework 8.15
--
-- Copyright 2014-2018 Gartle Technology Corporation
-- =============================================

UPDATE XLS.HANDLERS  SET HANDLER_CODE = 'TABLE, VIEW, PROCEDURE, FUNCTION, CODE, HTTP, TEXT, MACRO, CMD, VALUES, RANGE, REFRESH, MENUSEPARATOR, PDF, REPORT, SHOWSHEETS, HIDESHEETS, SELECTSHEET' WHERE TABLE_SCHEMA = 'XLS' AND TABLE_NAME = 'HANDLERS' AND COLUMN_NAME = 'HANDLER_TYPE' AND EVENT_NAME = 'ValidationList';

DROP VIEW IF EXISTS XLS.QUERIES;

CREATE VIEW XLS.QUERIES
AS
SELECT
    t.SCHEMA AS TABLE_SCHEMA
    , t.TABLENAME AS TABLE_NAME
    , t.TYPE AS TABLE_TYPE
    , NULL AS TABLE_CODE
    , NULL AS INSERT_PROCEDURE
    , NULL AS UPDATE_PROCEDURE
    , NULL AS DELETE_PROCEDURE
    , NULL AS PROCEDURE_TYPE
FROM
    SYSTEM.TABLES t
WHERE
    NOT t.SCHEMA IN ('SYSTEM', 'XLS', 'SAVETODB_DEV', 'SAVETODB_XLS')
    AND NOT t.TABLENAME LIKE 'XL_%'
UNION
SELECT
    r.SCHEMA AS TABLE_SCHEMA
    , r.PROCEDURENAME AS TABLE_NAME
    , 'PROCEDURE' AS TABLE_TYPE
    , NULL AS TABLE_CODE
    , NULL AS INSERT_PROCEDURE
    , NULL AS UPDATE_PROCEDURE
    , NULL AS DELETE_PROCEDURE
    , NULL AS PROCEDURE_TYPE
FROM 
    SYSTEM.PROCEDURES r
WHERE
    NOT r.SCHEMA IN ('SYSTEM', 'XLS', 'SAVETODB_DEV', 'SAVETODB_XLS')
    AND NOT (
        r.PROCEDURENAME LIKE '%_INSERT'
        OR r.PROCEDURENAME LIKE '%_UPDATE'
        OR r.PROCEDURENAME LIKE '%_DELETE'
        OR r.PROCEDURENAME LIKE '%_MERGE'
        OR r.PROCEDURENAME LIKE '%_CHANGE'
        OR r.PROCEDURENAME LIKE 'XL_%'
    )
UNION
SELECT
    o.TABLE_SCHEMA
    , o.TABLE_NAME
    , o.TABLE_TYPE
    , o.TABLE_CODE
    , o.INSERT_OBJECT AS INSERT_PROCEDURE
    , o.UPDATE_OBJECT AS UPDATE_PROCEDURE
    , o.DELETE_OBJECT AS DELETE_PROCEDURE
    , NULL AS PROCEDURE_TYPE
FROM
    XLS.OBJECTS o
WHERE
    o.TABLE_TYPE IN ('CODE', 'HTTP', 'TEXT')
    AND o.TABLE_SCHEMA IS NOT NULL
    AND o.TABLE_NAME IS NOT NULL
    AND o.TABLE_CODE IS NOT NULL
    AND NOT o.TABLE_NAME LIKE 'XL_%';

GRANT SELECT ON TABLE XLS.QUERIES       TO ROLE XLS.XLS_USERS;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE XLS.QUERIES       TO ROLE XLS.XLS_DEVELOPERS;
