-- =============================================
-- SaveToDB Framework for NuoDB
-- Version 8.7, March 12, 2018
--
-- This script upgrades SaveToDB Framework 8.6 to SaveToDB Framework 8.7
--
-- Copyright 2014-2018 Gartle Technology Corporation
-- =============================================

CREATE TABLE XLS.WORKBOOKS (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY,
    NAME STRING NOT NULL,
    TEMPLATE STRING,
    DEFINITION STRING NOT NULL,
    PRIMARY KEY (ID)
);

CREATE UNIQUE INDEX IX_WORKBOOKS ON XLS.WORKBOOKS (NAME);

GRANT SELECT ON TABLE XLS.WORKBOOKS     TO ROLE XLS.XLS_USERS;

GRANT SELECT, INSERT, UPDATE, DELETE ON TABLE XLS.WORKBOOKS     TO ROLE XLS.XLS_DEVELOPERS;

INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'WORKBOOKS',    NULL, 'Actions', 'HTTP', 'Online Help', 'HTTP', 'http://www.savetodb.com/savetodb8/configuring-workbooks.htm',         NULL, 11, NULL);
