-- =============================================
-- Application: Sample 13 - Tests
-- Version 10.8, January 9, 2023
--
-- Copyright 2021-2023 Gartle LLC
--
-- License: MIT
-- =============================================

CREATE SCHEMA S13;

CREATE TABLE S13.QUOTES (
    "," VARCHAR(50) NOT NULL
    , "-" VARCHAR(50) NOT NULL
    , "@" VARCHAR(50) NOT NULL
    , "@@" VARCHAR(50) NOT NULL
    , "`" VARCHAR(50) NULL
    , "``" VARCHAR(50) NULL
    , "]" VARCHAR(50) NULL
    , "[" VARCHAR(50) NULL
    , "[]" VARCHAR(50) NULL
    , "+" VARCHAR(50) NULL
    , "*" VARCHAR(50) NULL
    , "%" VARCHAR(50) NULL
    , "%%" VARCHAR(50) NULL
    , "=" VARCHAR(50) NULL
    , ";" VARCHAR(50) NULL
    , ":" VARCHAR(50) NULL
    , "<>" VARCHAR(50) NULL
    , "&" VARCHAR(50) NULL
    , "." VARCHAR(50) NULL
    , ".." VARCHAR(50) NULL
    , CONSTRAINT PK_QUOTES PRIMARY KEY (",", "-", "@", "@@")
);

CREATE TABLE S13.DATATYPES (
    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY
    , "BIGINT" BIGINT NULL
    , "BINARY" BINARY(8) NULL
    , "BLOB" BLOB NULL
    , "BOOLEAN" BOOLEAN NULL
    , "CLOB" CHARACTER LARGE OBJECT NULL
    , "VARCHAR" CHARACTER VARYING(255) NULL
    , "CHAR" CHARACTER(10) NULL
    , "CHAR36" CHARACTER(36) NULL
    , "DATE" DATE NULL
    , "DOUBLE" DOUBLE NULL
    , "INTEGER" INTEGER NULL
    , "NUMBER" NUMBER NULL
    , "NUMERIC" NUMERIC(15,2) NULL
    , "SMALLINT" SMALLINT NULL
    , "STRING" STRING NULL
    , "TEXT" TEXT NULL
    , "TIME" TIME NULL
    , "TIME0" TIME(0) NULL
    , "TIME3" TIME(3) NULL
    , "TIMESTAMP" TIMESTAMP NULL
    , "TIMESTAMP0" TIMESTAMP(0) NULL
    , "TIMESTAMP3" TIMESTAMP(3) NULL
    , "VARBINARY" VARBINARY(1024) NULL
    , CONSTRAINT PK_DATATYPES PRIMARY KEY (ID)
);

CREATE OR REPLACE VIEW S13.VIEW_DATATYPE_COLUMNS
AS
SELECT
    c.SCHEMA AS TABLE_SCHEMA
    , c.TABLENAME AS TABLE_NAME
    , c."FIELD" AS COLUMN_NAME
    , c.FIELDPOSITION AS ORDINAL_POSITION
    , CASE WHEN kcu.INDEXTYPE IS NULL THEN 0 ELSE 1 END AS IS_PRIMARY_KEY
    , CASE WHEN c.FLAGS % 2 = 1 THEN 0 ELSE 1 END AS IS_NULLABLE
    , CASE WHEN c.GENERATOR_SEQUENCE IS NULL THEN 0 ELSE 1 END AS IS_IDENTITY
    , CAST(NULL AS SMALLINT) AS IS_COMPUTED
    , c.DEFAULTVALUE AS COLUMN_DEFAULT
    , CASE WHEN c.ENUMERATION IS NOT NULL THEN 'enum' WHEN d.NAME = 'bigint' AND c.SCALE > 0 THEN 'numeric' ELSE d.NAME END AS DATA_TYPE
    , c.LENGTH AS MAX_LENGTH
    , c.PRECISION AS PRECISION
    , c.SCALE AS SCALE
FROM
    SYSTEM.FIELDS c
    INNER JOIN SYSTEM.DATATYPES d ON d.ID = c.DATATYPE
    LEFT OUTER JOIN (
        SELECT
            kcu.*
            , tc.INDEXTYPE
        FROM
            SYSTEM.INDEXFIELDS kcu
            LEFT OUTER JOIN SYSTEM.INDEXES tc
                ON tc.SCHEMA = kcu.SCHEMA AND tc.INDEXNAME = kcu.INDEXNAME
        WHERE
            tc.INDEXTYPE = 0
    ) kcu ON kcu.SCHEMA = c.SCHEMA AND kcu.TABLENAME = c.TABLENAME AND kcu.FIELD = c.FIELD
WHERE
    NOT c.SCHEMA IN ('SYSTEM')
    AND c.TABLENAME = 'DATATYPES';

CREATE OR REPLACE VIEW S13.VIEW_DATATYPE_PARAMETERS
AS
SELECT
    p.SCHEMA AS SPECIFIC_SCHEMA
    , p.PROCEDURENAME AS SPECIFIC_NAME
    , p.ORDINAL AS ORDINAL_POSITION
    , CASE p.TYPE WHEN 1 THEN 'IN' WHEN 2 THEN 'INOUT' WHEN 3 THEN 'OUT' ELSE NULL END AS PARAMETER_MODE
    , p.NAME AS PARAMETER_NAME
    , p.DATATYPENAME AS DATA_TYPE
    , p.LENGTH AS MAX_LENGTH
    , p.PRECISION AS PRECISION
    , p.SCALE AS SCALE
FROM
    SYSTEM.PROCEDURECOLUMNS p
WHERE
    p.PROCEDURENAME IN ('USP_DATATYPES', 'USP_DATATYPES_INSERT', 'USP_DATATYPES_UPDATE', 'USP_DATATYPES_DELETE');

SET DELIMITER @@

CREATE OR REPLACE PROCEDURE S13.USP_QUOTES (
    )
RETURNS tmp_tab (
    "," VARCHAR(50)
    , "-" VARCHAR(50)
    , "@" VARCHAR(50)
    , "@@" VARCHAR(50)
    , "`" VARCHAR(50)
    , "``" VARCHAR(50)
    , "]" VARCHAR(50)
    , "[" VARCHAR(50)
    , "[]" VARCHAR(50)
    , "+" VARCHAR(50)
    , "*" VARCHAR(50)
    , "%" VARCHAR(50)
    , "%%" VARCHAR(50)
    , "=" VARCHAR(50)
    , ";" VARCHAR(50)
    , ":" VARCHAR(50)
    , "<>" VARCHAR(50)
    , "&" VARCHAR(50)
    , "." VARCHAR(50)
    , ".." VARCHAR(50)
    )
AS

INSERT INTO tmp_tab
SELECT
    t.","
    , t."-"
    , t."@"
    , t."@@"
    , t."`"
    , t."``"
    , t."]"
    , t."["
    , t."[]"
    , t."+"
    , t."*"
    , t."%"
    , t."%%"
    , t."="
    , t.";"
    , t.":"
    , t."<>"
    , t."&"
    , t."."
    , t.".."
FROM
    S13.QUOTES t;

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_QUOTES_DELETE (
    "_x002C_" VARCHAR(50)
    , "_x002D_" VARCHAR(50)
    , "_x0040_" VARCHAR(50)
    , "_x0040__x0040_" VARCHAR(50)
    )
AS

DELETE FROM S13.QUOTES
WHERE
    "," = "_x002C_"
    AND "-" = "_x002D_"
    AND "@" = "_x0040_"
    AND "@@" = "_x0040__x0040_";

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_QUOTES_INSERT (
    "_x002C_" VARCHAR(50)
    , "_x002D_" VARCHAR(50)
    , "_x0040_" VARCHAR(50)
    , "_x0040__x0040_" VARCHAR(50)
    , "_x0060_" VARCHAR(50)
    , "_x0060__x0060_" VARCHAR(50)
    , "_x005D_" VARCHAR(50)
    , "_x005B_" VARCHAR(50)
    , "_x005B__x005D_" VARCHAR(50)
    , "_x002B_" VARCHAR(50)
    , "_x002A_" VARCHAR(50)
    , "_x0025_" VARCHAR(50)
    , "_x0025__x0025_" VARCHAR(50)
    , "_x003D_" VARCHAR(50)
    , "_x003B_" VARCHAR(50)
    , "_x003A_" VARCHAR(50)
    , "_x003C__x003E_" VARCHAR(50)
    , "_x0026_" VARCHAR(50)
    , "_x002E_" VARCHAR(50)
    , "_x002E__x002E_" VARCHAR(50)
    )
AS

INSERT INTO S13.QUOTES
    ( ","
    , "-"
    , "@"
    , "@@"
    , "`"
    , "``"
    , "]"
    , "["
    , "[]"
    , "+"
    , "*"
    , "%"
    , "%%"
    , "="
    , ";"
    , ":"
    , "<>"
    , "&"
    , "."
    , ".."
    )
VALUES
    ( "_x002C_"
    , "_x002D_"
    , "_x0040_"
    , "_x0040__x0040_"
    , "_x0060_"
    , "_x0060__x0060_"
    , "_x005D_"
    , "_x005B_"
    , "_x005B__x005D_"
    , "_x002B_"
    , "_x002A_"
    , "_x0025_"
    , "_x0025__x0025_"
    , "_x003D_"
    , "_x003B_"
    , "_x003A_"
    , "_x003C__x003E_"
    , "_x0026_"
    , "_x002E_"
    , "_x002E__x002E_"
    );

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_QUOTES_UPDATE (
    "_x002C_" VARCHAR(50)
    , "_x002D_" VARCHAR(50)
    , "_x0040_" VARCHAR(50)
    , "_x0040__x0040_" VARCHAR(50)
    , "_x0060_" VARCHAR(50)
    , "_x0060__x0060_" VARCHAR(50)
    , "_x005D_" VARCHAR(50)
    , "_x005B_" VARCHAR(50)
    , "_x005B__x005D_" VARCHAR(50)
    , "_x002B_" VARCHAR(50)
    , "_x002A_" VARCHAR(50)
    , "_x0025_" VARCHAR(50)
    , "_x0025__x0025_" VARCHAR(50)
    , "_x003D_" VARCHAR(50)
    , "_x003B_" VARCHAR(50)
    , "_x003A_" VARCHAR(50)
    , "_x003C__x003E_" VARCHAR(50)
    , "_x0026_" VARCHAR(50)
    , "_x002E_" VARCHAR(50)
    , "_x002E__x002E_" VARCHAR(50)
    )
AS

UPDATE S13.QUOTES
SET
    "`" = "_x0060_"
    , "``" = "_x0060__x0060_"
    , "]" = "_x005D_"
    , "[" = "_x005B_"
    , "[]" = "_x005B__x005D_"
    , "+" = "_x002B_"
    , "*" = "_x002A_"
    , "%" = "_x0025_"
    , "%%" = "_x0025__x0025_"
    , "=" = "_x003D_"
    , ";" = "_x003B_"
    , ":" = "_x003A_"
    , "<>" = "_x003C__x003E_"
    , "&" = "_x0026_"
    , "." = "_x002E_"
    , ".." = "_x002E__x002E_"
WHERE
    "," = "_x002C_"
    AND "-" = "_x002D_"
    AND "@" = "_x0040_"
    AND "@@" = "_x0040__x0040_";

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_DATATYPES (
    )
RETURNS tmp_tab (
    ID INTEGER
    , "BIGINT" BIGINT
    , "BOOLEAN" BOOLEAN
    , "CLOB" CHARACTER LARGE OBJECT
    , "VARCHAR" CHARACTER VARYING(255)
    , "CHAR" CHARACTER(10)
    , "CHAR36" CHARACTER(36)
    , "DATE" DATE
    , "DOUBLE" DOUBLE
    , "INTEGER" INTEGER
    , "NUMBER" NUMBER
    , "NUMERIC" NUMERIC(15,2)
    , "SMALLINT" SMALLINT
    , "STRING" STRING
    , "TEXT" TEXT
    , "TIME" STRING
    , "TIME0" STRING
    , "TIME3" STRING
    , "TIMESTAMP" TIMESTAMP
    , "TIMESTAMP0" TIMESTAMP(0)
    , "TIMESTAMP3" TIMESTAMP(3)
    )
AS

INSERT INTO tmp_tab
SELECT
    t."ID"
    , t."BIGINT"
    , t."BOOLEAN"
    , t."CLOB"
    , t."VARCHAR"
    , t."CHAR"
    , t."CHAR36"
    , t."DATE"
    , t."DOUBLE"
    , t."INTEGER"
    , t."NUMBER"
    , t."NUMERIC"
    , t."SMALLINT"
    , t."STRING"
    , t."TEXT"
    , t."TIME"
    , t."TIME0"
    , t."TIME3"
    , t."TIMESTAMP"
    , t."TIMESTAMP0"
    , t."TIMESTAMP3"
FROM
    S13.DATATYPES t;

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_DATATYPES_DELETE (
    ID INTEGER
    )
AS

VAR P_ID INTEGER = ID;

DELETE FROM S13.DATATYPES t
WHERE
    t.ID = P_ID;

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_DATATYPES_INSERT (
    "BIGINT" BIGINT
    , "BOOLEAN" BOOLEAN
    , "CLOB" CHARACTER LARGE OBJECT
    , "VARCHAR" CHARACTER VARYING(255)
    , "CHAR" CHARACTER(10)
    , "CHAR36" CHARACTER(36)
    , "DATE" DATE
    , "DOUBLE" DOUBLE
    , "INTEGER" INTEGER
    , "NUMBER" NUMBER
    , "NUMERIC" NUMERIC(15,2)
    , "SMALLINT" SMALLINT
    , "STRING" STRING
    , "TEXT" TEXT
    , "TIME" TIME
    , "TIME0" TIME(0)
    , "TIME3" TIME(3)
    , "TIMESTAMP" TIMESTAMP
    , "TIMESTAMP0" TIMESTAMP(0)
    , "TIMESTAMP3" TIMESTAMP(3)
    )
AS

INSERT INTO S13.DATATYPES
    ( "BIGINT"
    , "BOOLEAN"
    , "CLOB"
    , "VARCHAR"
    , "CHAR"
    , "CHAR36"
    , "DATE"
    , "DOUBLE"
    , "INTEGER"
    , "NUMBER"
    , "NUMERIC"
    , "SMALLINT"
    , "STRING"
    , "TEXT"
    , "TIME"
    , "TIME0"
    , "TIME3"
    , "TIMESTAMP"
    , "TIMESTAMP0"
    , "TIMESTAMP3"
    )
VALUES
    ( "BIGINT"
    , "BOOLEAN"
    , "CLOB"
    , "VARCHAR"
    , "CHAR"
    , "CHAR36"
    , "DATE"
    , "DOUBLE"
    , "INTEGER"
    , "NUMBER"
    , "NUMERIC"
    , "SMALLINT"
    , "STRING"
    , "TEXT"
    , "TIME"
    , "TIME0"
    , "TIME3"
    , "TIMESTAMP"
    , "TIMESTAMP0"
    , "TIMESTAMP3"
    );

END_PROCEDURE
@@

CREATE OR REPLACE PROCEDURE S13.USP_DATATYPES_UPDATE (
    "ID" INTEGER
    , "BIGINT" BIGINT
    , "BOOLEAN" BOOLEAN
    , "CLOB" CHARACTER LARGE OBJECT
    , "VARCHAR" CHARACTER VARYING(255)
    , "CHAR" CHARACTER(10)
    , "CHAR36" CHARACTER(36)
    , "DATE" DATE
    , "DOUBLE" DOUBLE
    , "INTEGER" INTEGER
    , "NUMBER" NUMBER
    , "NUMERIC" NUMERIC(15,2)
    , "SMALLINT" SMALLINT
    , "STRING" STRING
    , "TEXT" TEXT
    , "TIME" TIME
    , "TIME0" TIME(0)
    , "TIME3" TIME(3)
    , "TIMESTAMP" TIMESTAMP
    , "TIMESTAMP0" TIMESTAMP(0)
    , "TIMESTAMP3" TIMESTAMP(3)
    )
AS

VAR P_ID INTEGER = ID;
VAR P_BIGINT BIGINT="BIGINT";
VAR P_BOOLEAN BOOLEAN="BOOLEAN";
VAR P_CLOB CHARACTER LARGE OBJECT="CLOB";
VAR P_VARCHAR CHARACTER VARYING(255)="VARCHAR";
VAR P_CHAR CHARACTER(10)="CHAR";
VAR P_CHAR36 CHARACTER(36)="CHAR36";
VAR P_DATE DATE="DATE";
VAR P_DOUBLE DOUBLE="DOUBLE";
VAR P_INTEGER INTEGER="INTEGER";
VAR P_NUMBER NUMBER="NUMBER";
VAR P_NUMERIC NUMERIC(15,2)="NUMERIC";
VAR P_SMALLINT SMALLINT="SMALLINT";
VAR P_STRING STRING="STRING";
VAR P_TEXT TEXT="TEXT";
VAR P_TIME TIME="TIME";
VAR P_TIME0 TIME(0)="TIME0";
VAR P_TIME3 TIME(3)="TIME3";
VAR P_TIMESTAMP TIMESTAMP="TIMESTAMP";
VAR P_TIMESTAMP0 TIMESTAMP(0)="TIMESTAMP0";
VAR P_TIMESTAMP3 TIMESTAMP(3)="TIMESTAMP3";

UPDATE S13.DATATYPES
SET
    "BIGINT" = P_BIGINT
    , "BOOLEAN" = P_BOOLEAN
    , "CLOB" = P_CLOB
    , "VARCHAR" = P_VARCHAR
    , "CHAR" = P_CHAR
    , "CHAR36" = P_CHAR36
    , "DATE" = P_DATE
    , "DOUBLE" = P_DOUBLE
    , "INTEGER" = P_INTEGER
    , "NUMBER" = P_NUMBER
    , "NUMERIC" = P_NUMERIC
    , "SMALLINT" = P_SMALLINT
    , "STRING" = P_STRING
    , "TEXT" = P_TEXT
    , "TIME" = P_TIME
    , "TIME0" = P_TIME0
    , "TIME3" = P_TIME3
    , "TIMESTAMP" = P_TIMESTAMP
    , "TIMESTAMP0" = P_TIMESTAMP0
    , "TIMESTAMP3" = P_TIMESTAMP3
WHERE
    ID = P_ID;

END_PROCEDURE
@@

SET DELIMITER ;

INSERT INTO "S13"."DATATYPES" ("BIGINT","BINARY","BLOB","BOOLEAN","CLOB","VARCHAR","CHAR","CHAR36","DATE","DOUBLE","INTEGER","NUMBER","NUMERIC","SMALLINT","STRING","TEXT","TIME","TIME0","TIME3","TIMESTAMP","TIMESTAMP0","TIMESTAMP3","VARBINARY") VALUES (123456789012345,NULL,NULL,1,'clob','varchar','char','00010203-0405-0607-0809-0a0b0c0d0e0f','2021-12-10',123456789012.12,2147483647,'123456789012.12',1234567890,32767,'string','text','0001-01-01 15:20:10.1234567','0001-01-01 15:20:10','0001-01-01 15:20:10.123','2021-12-10 15:20:10.1234567','2021-12-10 15:20:10','2021-12-10 15:20:10.123',NULL);
INSERT INTO "S13"."DATATYPES" ("BIGINT","BINARY","BLOB","BOOLEAN","CLOB","VARCHAR","CHAR","CHAR36","DATE","DOUBLE","INTEGER","NUMBER","NUMERIC","SMALLINT","STRING","TEXT","TIME","TIME0","TIME3","TIMESTAMP","TIMESTAMP0","TIMESTAMP3","VARBINARY") VALUES (123456789012345,NULL,NULL,1,'clob','varchar','char','00010203-0405-0607-0809-0a0b0c0d0e0f','2021-12-10',123456789012.12,2147483647,'123456789012.12',1234567890,32767,'string','text','0001-01-01 15:20:10.1234567','0001-01-01 15:20:10','0001-01-01 15:20:10.123','2021-12-10 15:20:10.1234567','2021-12-10 15:20:10','2021-12-10 15:20:10.123',NULL);
INSERT INTO "S13"."DATATYPES" ("BIGINT") VALUES (NULL);

INSERT INTO "S13"."QUOTES" (",", "-", "@", "@@", "`", "``", "]", "[", "[]", "+", "*", "%", "%%", "=", ";", ":", "<>", "&", ".", "..") VALUES (',', '-', '@', '@@', '`', '``', ']', '[', '[]', '+', '*', '%', '%%', '=', ';', ':', '<>', '&', '.', '..');
INSERT INTO "S13"."QUOTES" (",", "-", "@", "@@", "`", "``", "]", "[", "[]", "+", "*", "%", "%%", "=", ";", ":", "<>", "&", ".", "..") VALUES ('3', '4', '5', '6', '`', '``', ']', '[', '[]', '+', '*', '%', '%%', '=', ';', ':', '<>', '&', '.', '..');

-- print Application installed
