SELECT
    t.SCHEMA AS SCHEMA
    , t.TABLENAME AS NAME
    , t.TYPE AS TYPE
FROM
    SYSTEM.TABLES t
WHERE
    t.SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS')
UNION ALL
SELECT
    r.SCHEMA
    , r.PROCEDURENAME AS NAME
    , 'PROCEDURE' AS TYPE
FROM 
    SYSTEM.PROCEDURES r
WHERE
    r.SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS')
ORDER BY
    SCHEMA
    , TYPE
    , NAME