-- =============================================
-- SaveToDB Framework for NuoDB
-- Version 7.19, March 12, 2018
--
-- This script copies settings from SaveToDB Framework 5-7 to SaveToDB Framework 8.
-- SaveToDB Framework 8 must be installed.
-- You may remove SaveToDB Framework 5-7 manually after successful copying.
--
-- Copyright 2018 Gartle Technology Corporation
-- =============================================

-- print Copying table data:

-- print SAVETODB_DEV.QUERY_LIST         -> XLS.OBJECTS

INSERT INTO XLS.OBJECTS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , TABLE_TYPE
    , TABLE_CODE
    , INSERT_OBJECT
    , UPDATE_OBJECT
    , DELETE_OBJECT
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , s.TABLE_TYPE
    , s.TABLE_CODE
    , s.INSERT_PROCEDURE
    , s.UPDATE_PROCEDURE
    , s.DELETE_PROCEDURE
FROM
    SAVETODB_DEV.QUERY_LIST s
    LEFT OUTER JOIN XLS.OBJECTS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
WHERE
    NOT s.TABLE_SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS', 'SAVETODB_ETL', 'HTTP01')
    AND t.ID IS NULL;

-- print SAVETODB_DEV.EVENT_HANDLERS     -> XLS.HANDLERS

INSERT INTO XLS.HANDLERS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , COLUMN_NAME
    , EVENT_NAME
    , HANDLER_SCHEMA
    , HANDLER_NAME
    , HANDLER_TYPE
    , HANDLER_CODE
    , TARGET_WORKSHEET
    , MENU_ORDER
    , EDIT_PARAMETERS
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , s.COLUMN_NAME
    , s.EVENT_NAME
    , s.HANDLER_SCHEMA
    , s.HANDLER_NAME
    , s.HANDLER_TYPE
    , s.HANDLER_CODE
    , s.TARGET_WORKSHEET
    , s.MENU_ORDER
    , s.EDIT_PARAMETERS
FROM
    SAVETODB_DEV.EVENT_HANDLERS s
    LEFT OUTER JOIN XLS.HANDLERS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
        AND COALESCE(t.COLUMN_NAME, '')     = COALESCE(s.COLUMN_NAME, '')
        AND COALESCE(t.HANDLER_SCHEMA, '')  = COALESCE(s.HANDLER_SCHEMA, '')
        AND COALESCE(t.HANDLER_NAME, '')    = COALESCE(s.HANDLER_NAME, '')
        AND COALESCE(t.HANDLER_TYPE, '')    = COALESCE(s.HANDLER_TYPE, '')
        AND COALESCE(t.MENU_ORDER, 0)       = COALESCE(s.MENU_ORDER, 0)
WHERE
    NOT s.TABLE_SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS', 'SAVETODB_ETL', 'HTTP01')
    AND t.ID IS NULL;

-- print SAVETODB_DEV.PARAMETER_VALUES   -> XLS.HANDLERS

INSERT INTO XLS.HANDLERS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , COLUMN_NAME
    , EVENT_NAME
    , HANDLER_SCHEMA
    , HANDLER_NAME
    , HANDLER_TYPE
    , HANDLER_CODE
    , TARGET_WORKSHEET
    , MENU_ORDER
    , EDIT_PARAMETERS
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , s.PARAMETER_NAME  AS COLUMN_NAME
    , 'ParameterValues' AS EVENT_NAME
    , s.SELECT_SCHEMA   AS HANDLER_SCHEMA
    , s.SELECT_NAME     AS HANDLER_NAME
    , s.SELECT_TYPE     AS HANDLER_TYPE
    , s.SELECT_CODE     AS HANDLER_CODE
    , NULL              AS TARGET_WORKSHEET
    , NULL              AS MENU_ORDER
    , NULL              AS EDIT_PARAMETERS
FROM
    SAVETODB_DEV.PARAMETER_VALUES s
    LEFT OUTER JOIN XLS.HANDLERS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
        AND COALESCE(s.PARAMETER_NAME, '')  = COALESCE(t.COLUMN_NAME, '')
        AND COALESCE(s.SELECT_SCHEMA, '')   = COALESCE(t.HANDLER_SCHEMA, '')
        AND COALESCE(s.SELECT_NAME, '')     = COALESCE(t.HANDLER_NAME, '')
        AND COALESCE(s.SELECT_TYPE, '')     = COALESCE(t.HANDLER_TYPE, '')
WHERE
    NOT s.TABLE_SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS', 'SAVETODB_ETL', 'HTTP01')
    AND t.ID IS NULL;

-- print SAVETODB_DEV.OBJECT_TRANSLATION -> XLS.TRANSLATIONS

INSERT INTO XLS.TRANSLATIONS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , COLUMN_NAME
    , LANGUAGE_NAME
    , TRANSLATED_NAME
    , TRANSLATED_DESC
    , TRANSLATED_COMMENT
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , NULL AS COLUMN_NAME
    , s.LANGUAGE_NAME
    , s.TRANSLATED_NAME
    , s.TRANSLATED_DESC
    , s.TRANSLATED_COMMENT
FROM
    SAVETODB_DEV.OBJECT_TRANSLATION s
    LEFT OUTER JOIN XLS.TRANSLATIONS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
        AND t.LANGUAGE_NAME = s.LANGUAGE_NAME AND t.COLUMN_NAME IS NULL
WHERE
    NOT s.TABLE_SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS', 'SAVETODB_ETL', 'HTTP01')
    AND t.ID IS NULL;

-- print SAVETODB_DEV.COLUMN_TRANSLATION -> XLS.TRANSLATIONS

INSERT INTO XLS.TRANSLATIONS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , COLUMN_NAME
    , LANGUAGE_NAME
    , TRANSLATED_NAME
    , TRANSLATED_DESC
    , TRANSLATED_COMMENT
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , s.COLUMN_NAME
    , s.LANGUAGE_NAME
    , s.TRANSLATED_NAME
    , s.TRANSLATED_DESC
    , NULL AS TRANSLATED_COMMENT
FROM
    SAVETODB_DEV.COLUMN_TRANSLATION s
    LEFT OUTER JOIN XLS.TRANSLATIONS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
        AND t.LANGUAGE_NAME = s.LANGUAGE_NAME AND t.COLUMN_NAME = s.COLUMN_NAME
WHERE
    NOT s.TABLE_SCHEMA IN ('SAVETODB_DEV', 'SAVETODB_XLS', 'SAVETODB_ETL', 'HTTP01')
    AND t.ID IS NULL;

-- print SAVETODB_DEV.TABLE_FORMATS      -> XLS.FORMATS

INSERT INTO XLS.FORMATS
    ( TABLE_SCHEMA
    , TABLE_NAME
    , TABLE_EXCEL_FORMAT_XML
    )
SELECT
    s.TABLE_SCHEMA
    , s.TABLE_NAME
    , s.TABLE_EXCEL_FORMAT_XML
FROM
    SAVETODB_DEV.TABLE_FORMATS s
    LEFT OUTER JOIN XLS.FORMATS t ON t.TABLE_SCHEMA = s.TABLE_SCHEMA AND t.TABLE_NAME = s.TABLE_NAME
WHERE
    t.ID IS NULL;
