-- =============================================
-- SaveToDB Framework for NuoDB
-- Version 7.19, March 12, 2018
--
-- This script upgrades SaveToDB Framework 6.x to SaveToDB Framework 7.19
--
-- Copyright 2014-2018 Gartle Technology Corporation
-- =============================================

DELETE FROM "SAVETODB_DEV"."TABLE_FORMATS" WHERE "TABLE_SCHEMA" = 'SAVETODB_DEV' AND "TABLE_NAME" = 'EVENT_HANDLERS';

INSERT INTO "SAVETODB_DEV"."TABLE_FORMATS" ("TABLE_SCHEMA", "TABLE_NAME", "TABLE_EXCEL_FORMAT_XML") VALUES ('SAVETODB_DEV', 'EVENT_HANDLERS', '<?xml version="1.0" encoding="Unicode"?>
<table name="SAVETODB_DEV.EVENT_HANDLERS">
<columnFormats>
<column name="" property="ListObjectName" value="EventHandlers_Table1" type="String" />
<column name="" property="ShowTotals" value="False" type="Boolean" />
<column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" />
<column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" />
<column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" />
<column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" />
<column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" />
<column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" />
<column name="_RowNum" property="Address" value="$B$7" type="String" />
<column name="ID" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="ID" property="Address" value="$C$7" type="String" />
<column name="ID" property="ColumnWidth" value="4.43" type="Double" />
<column name="ID" property="Validation.Type" value="1" type="Double" />
<column name="ID" property="Validation.AlertStyle" value="1" type="Double" />
<column name="ID" property="Validation.Operator" value="1" type="Double" />
<column name="ID" property="Validation.Formula1" value="-2147483648" type="String" />
<column name="ID" property="Validation.Formula2" value="2147483647" type="String" />
<column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="ID" property="Validation.ErrorMessage" value="The column requires values of the integer datatype." type="String" />
<column name="ID" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="ID" property="Validation.ShowError" value="True" type="Boolean" />
<column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_SCHEMA" property="Address" value="$D$7" type="String" />
<column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" />
<column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_NAME" property="Address" value="$E$7" type="String" />
<column name="TABLE_NAME" property="ColumnWidth" value="27.86" type="Double" />
<column name="COLUMN_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="COLUMN_NAME" property="Address" value="$F$7" type="String" />
<column name="COLUMN_NAME" property="ColumnWidth" value="17.43" type="Double" />
<column name="EVENT_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="EVENT_NAME" property="Address" value="$G$7" type="String" />
<column name="EVENT_NAME" property="ColumnWidth" value="15" type="Double" />
<column name="EVENT_NAME" property="Validation.Type" value="3" type="Double" />
<column name="EVENT_NAME" property="Validation.AlertStyle" value="1" type="Double" />
<column name="EVENT_NAME" property="Validation.Operator" value="8" type="Double" />
<column name="EVENT_NAME" property="Validation.Formula1" value="Actions;Change;ContextMenu;DoubleClick;SelectionChange;DoNotSelect;DoNotSave;DoNotChange;ProtectRows;Formula;FormulaValue;ValidationList;SelectionList" type="String" />
<column name="EVENT_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="EVENT_NAME" property="Validation.ErrorMessage" value="The column requires values of the varchar(50) datatype." type="String" />
<column name="EVENT_NAME" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.ShowError" value="True" type="Boolean" />
<column name="HANDLER_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_SCHEMA" property="Address" value="$H$7" type="String" />
<column name="HANDLER_SCHEMA" property="ColumnWidth" value="26.14" type="Double" />
<column name="HANDLER_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_NAME" property="Address" value="$I$7" type="String" />
<column name="HANDLER_NAME" property="ColumnWidth" value="26.14" type="Double" />
<column name="HANDLER_TYPE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_TYPE" property="Address" value="$J$7" type="String" />
<column name="HANDLER_TYPE" property="ColumnWidth" value="16.29" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Type" value="3" type="Double" />
<column name="HANDLER_TYPE" property="Validation.AlertStyle" value="1" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Operator" value="8" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Formula1" value="TABLE;VIEW;PROCEDURE;FUNCTION;CODE;HTTP;TEXT;MACRO;CMD;REFRESH;MENUSEPARATOR" type="String" />
<column name="HANDLER_TYPE" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="HANDLER_TYPE" property="Validation.ErrorMessage" value="The column requires values of the varchar(64) datatype." type="String" />
<column name="HANDLER_TYPE" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.ShowError" value="True" type="Boolean" />
<column name="HANDLER_CODE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_CODE" property="Address" value="$K$7" type="String" />
<column name="HANDLER_CODE" property="ColumnWidth" value="70.71" type="Double" />
<column name="TARGET_WORKSHEET" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Address" value="$L$7" type="String" />
<column name="TARGET_WORKSHEET" property="ColumnWidth" value="21.71" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Type" value="6" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.AlertStyle" value="1" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Operator" value="8" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Formula1" value="256" type="String" />
<column name="TARGET_WORKSHEET" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="TARGET_WORKSHEET" property="Validation.ErrorMessage" value="The column requires values of the varchar(256) datatype." type="String" />
<column name="TARGET_WORKSHEET" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.ShowError" value="True" type="Boolean" />
<column name="MENU_ORDER" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="MENU_ORDER" property="Address" value="$M$7" type="String" />
<column name="MENU_ORDER" property="ColumnWidth" value="15.43" type="Double" />
<column name="MENU_ORDER" property="Validation.Type" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.AlertStyle" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.Operator" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.Formula1" value="-32768" type="String" />
<column name="MENU_ORDER" property="Validation.Formula2" value="32767" type="String" />
<column name="MENU_ORDER" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="MENU_ORDER" property="Validation.ErrorMessage" value="The column requires values of the smallint datatype." type="String" />
<column name="MENU_ORDER" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.ShowError" value="True" type="Boolean" />
<column name="EDIT_PARAMETERS" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="EDIT_PARAMETERS" property="Address" value="$N$7" type="String" />
<column name="EDIT_PARAMETERS" property="ColumnWidth" value="19.57" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).AppliesTo.Address" value="$D$7:$D$12" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Priority" value="1" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Formula1" value="=ISBLANK(D7)" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" />
<column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" />
<column name="" property="ActiveWindow.Split" value="True" type="Boolean" />
<column name="" property="ActiveWindow.SplitRow" value="0" type="Double" />
<column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" />
<column name="" property="PageSetup.Orientation" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" />
</columnFormats>
</table>
');

-- 7.19

DELETE FROM "SAVETODB_DEV"."TABLE_FORMATS" WHERE "TABLE_SCHEMA" = 'SAVETODB_DEV' AND "TABLE_NAME" = 'PARAMETER_VALUES';


INSERT INTO "SAVETODB_DEV"."TABLE_FORMATS" ("TABLE_SCHEMA", "TABLE_NAME", "TABLE_EXCEL_FORMAT_XML") VALUES ('SAVETODB_DEV', 'PARAMETER_VALUES', '<?xml version="1.0" encoding="Unicode"?>
<table name="SAVETODB_DEV.PARAMETER_VALUES">
<columnFormats>
<column name="" property="ListObjectName" value="ParameterValues_Table1" type="String" />
<column name="" property="ShowTotals" value="False" type="Boolean" />
<column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" />
<column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" />
<column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" />
<column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" />
<column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" />
<column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" />
<column name="_RowNum" property="Address" value="$B$7" type="String" />
<column name="ID" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="ID" property="Address" value="$C$7" type="String" />
<column name="ID" property="ColumnWidth" value="4.43" type="Double" />
<column name="ID" property="Validation.Type" value="1" type="Double" />
<column name="ID" property="Validation.AlertStyle" value="1" type="Double" />
<column name="ID" property="Validation.Operator" value="1" type="Double" />
<column name="ID" property="Validation.Formula1" value="-2147483648" type="String" />
<column name="ID" property="Validation.Formula2" value="2147483647" type="String" />
<column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="ID" property="Validation.ErrorMessage" value="The column requires values of the integer datatype." type="String" />
<column name="ID" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="ID" property="Validation.ShowError" value="True" type="Boolean" />
<column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_SCHEMA" property="Address" value="$D$7" type="String" />
<column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" />
<column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_NAME" property="Address" value="$E$7" type="String" />
<column name="TABLE_NAME" property="ColumnWidth" value="21.71" type="Double" />
<column name="PARAMETER_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="PARAMETER_NAME" property="Address" value="$F$7" type="String" />
<column name="PARAMETER_NAME" property="ColumnWidth" value="20.29" type="Double" />
<column name="SELECT_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="SELECT_SCHEMA" property="Address" value="$G$7" type="String" />
<column name="SELECT_SCHEMA" property="ColumnWidth" value="17.29" type="Double" />
<column name="SELECT_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="SELECT_NAME" property="Address" value="$H$7" type="String" />
<column name="SELECT_NAME" property="ColumnWidth" value="15.29" type="Double" />
<column name="SELECT_TYPE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="SELECT_TYPE" property="Address" value="$I$7" type="String" />
<column name="SELECT_TYPE" property="ColumnWidth" value="13.86" type="Double" />
<column name="SELECT_TYPE" property="Validation.Type" value="3" type="Double" />
<column name="SELECT_TYPE" property="Validation.AlertStyle" value="1" type="Double" />
<column name="SELECT_TYPE" property="Validation.Operator" value="8" type="Double" />
<column name="SELECT_TYPE" property="Validation.Formula1" value="TABLE;VIEW;PROCEDURE;FUNCTION;CODE;HTTP;VALUES;RANGE" type="String" />
<column name="SELECT_TYPE" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="SELECT_TYPE" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="SELECT_TYPE" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="SELECT_TYPE" property="Validation.ErrorMessage" value="The column requires values of the varchar(64) datatype." type="String" />
<column name="SELECT_TYPE" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="SELECT_TYPE" property="Validation.ShowError" value="True" type="Boolean" />
<column name="SELECT_CODE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="SELECT_CODE" property="Address" value="$J$7" type="String" />
<column name="SELECT_CODE" property="ColumnWidth" value="58" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).AppliesTo.Address" value="$D$7:$D$8" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Priority" value="1" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Formula1" value="=ISBLANK(D7)" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="TABLE_NAME" property="FormatConditions(1).AppliesTo.Address" value="$E$7:$E$8" type="String" />
<column name="TABLE_NAME" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="TABLE_NAME" property="FormatConditions(1).Priority" value="2" type="Double" />
<column name="TABLE_NAME" property="FormatConditions(1).Formula1" value="=ISBLANK(E7)" type="String" />
<column name="TABLE_NAME" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="TABLE_NAME" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="PARAMETER_NAME" property="FormatConditions(1).AppliesTo.Address" value="$F$7:$F$8" type="String" />
<column name="PARAMETER_NAME" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="PARAMETER_NAME" property="FormatConditions(1).Priority" value="3" type="Double" />
<column name="PARAMETER_NAME" property="FormatConditions(1).Formula1" value="=ISBLANK(F7)" type="String" />
<column name="PARAMETER_NAME" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="PARAMETER_NAME" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="SELECT_NAME" property="FormatConditions(1).AppliesTo.Address" value="$H$7:$H$8" type="String" />
<column name="SELECT_NAME" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="SELECT_NAME" property="FormatConditions(1).Priority" value="4" type="Double" />
<column name="SELECT_NAME" property="FormatConditions(1).Formula1" value="=ISBLANK(H7)" type="String" />
<column name="SELECT_NAME" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="SELECT_NAME" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" />
<column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" />
<column name="" property="ActiveWindow.Split" value="True" type="Boolean" />
<column name="" property="ActiveWindow.SplitRow" value="0" type="Double" />
<column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" />
<column name="" property="PageSetup.Orientation" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" />
</columnFormats>
</table>
');

ALTER TABLE "SAVETODB_DEV"."EVENT_HANDLERS" ALTER COLUMN "HANDLER_NAME" NULL;

INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'QUERY_LIST', 'TABLE_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,CODE,HTTP,TEXT');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'QUERY_LIST', 'PROCEDURE_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,PROCEDURE,CODE,MERGE');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'EVENT_HANDLERS', 'EVENT_NAME', 'ValidationList', NULL, '', 'VALUES', 'Actions,Change,ContextMenu,DoubleClick,SelectionChange,ConvertFormulas,DoNotConvertFormulas,DoNotSelect,DoNotSave,DoNotChange,ProtectRows,Formula,FormulaValue,ValidationList,SelectionList');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'EVENT_HANDLERS', 'HANDLER_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,FUNCTION,CODE,HTTP,TEXT,MACRO,CMD,VALUES,RANGE,REFRESH,MENUSEPARATOR');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'PARAMETER_VALUES', 'SELECT_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,FUNCTION,CODE,HTTP,VALUES,RANGE');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_QUERY_LIST', 'TABLE_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,CODE,HTTP,TEXT');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_QUERY_LIST', 'PROCEDURE_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,PROCEDURE,CODE,MERGE');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_EVENT_HANDLERS', 'EVENT_NAME', 'ValidationList', NULL, '', 'VALUES', 'Actions,Change,ContextMenu,DoubleClick,SelectionChange,ConvertFormulas,DoNotConvertFormulas,DoNotSelect,DoNotSave,DoNotChange,ProtectRows,Formula,FormulaValue,ValidationList,SelectionList');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_EVENT_HANDLERS', 'HANDLER_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,FUNCTION,CODE,HTTP,TEXT,MACRO,CMD,VALUES,RANGE,REFRESH,MENUSEPARATOR');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_PARAMETER_VALUES', 'SELECT_TYPE', 'ValidationList', NULL, '', 'VALUES', 'TABLE,VIEW,PROCEDURE,FUNCTION,CODE,HTTP,VALUES,RANGE');
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_DEV', 'EVENT_HANDLERS', 'HANDLER_CODE', 'DoNotConvertFormulas', NULL, '', NULL, NULL);
INSERT INTO "SAVETODB_DEV"."EVENT_HANDLERS" ("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "EVENT_NAME", "HANDLER_SCHEMA", "HANDLER_NAME", "HANDLER_TYPE", "HANDLER_CODE") VALUES ('SAVETODB_XLS', 'VIEW_EVENT_HANDLERS', 'HANDLER_CODE', 'DoNotConvertFormulas', NULL, '', NULL, NULL);

DELETE FROM "SAVETODB_DEV"."TABLE_FORMATS" WHERE "TABLE_SCHEMA" = 'SAVETODB_DEV' AND "TABLE_NAME" = 'EVENT_HANDLERS';

INSERT INTO "SAVETODB_DEV"."TABLE_FORMATS" ("TABLE_SCHEMA", "TABLE_NAME", "TABLE_EXCEL_FORMAT_XML") VALUES ('SAVETODB_DEV', 'EVENT_HANDLERS', '<?xml version="1.0" encoding="Unicode"?>
<table name="SAVETODB_DEV.EVENT_HANDLERS">
<columnFormats>
<column name="" property="ListObjectName" value="EventHandlers_Table1" type="String" />
<column name="" property="ShowTotals" value="False" type="Boolean" />
<column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" />
<column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" />
<column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" />
<column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" />
<column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" />
<column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" />
<column name="_RowNum" property="Address" value="$B$7" type="String" />
<column name="ID" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="ID" property="Address" value="$C$7" type="String" />
<column name="ID" property="ColumnWidth" value="4.43" type="Double" />
<column name="ID" property="Validation.Type" value="1" type="Double" />
<column name="ID" property="Validation.AlertStyle" value="1" type="Double" />
<column name="ID" property="Validation.Operator" value="1" type="Double" />
<column name="ID" property="Validation.Formula1" value="-2147483648" type="String" />
<column name="ID" property="Validation.Formula2" value="2147483647" type="String" />
<column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="ID" property="Validation.ErrorMessage" value="The column requires values of the integer datatype." type="String" />
<column name="ID" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="ID" property="Validation.ShowError" value="True" type="Boolean" />
<column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_SCHEMA" property="Address" value="$D$7" type="String" />
<column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" />
<column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TABLE_NAME" property="Address" value="$E$7" type="String" />
<column name="TABLE_NAME" property="ColumnWidth" value="27.86" type="Double" />
<column name="COLUMN_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="COLUMN_NAME" property="Address" value="$F$7" type="String" />
<column name="COLUMN_NAME" property="ColumnWidth" value="17.43" type="Double" />
<column name="EVENT_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="EVENT_NAME" property="Address" value="$G$7" type="String" />
<column name="EVENT_NAME" property="ColumnWidth" value="15" type="Double" />
<column name="EVENT_NAME" property="Validation.Type" value="3" type="Double" />
<column name="EVENT_NAME" property="Validation.AlertStyle" value="1" type="Double" />
<column name="EVENT_NAME" property="Validation.Operator" value="8" type="Double" />
<column name="EVENT_NAME" property="Validation.Formula1" value="Actions;Change;ContextMenu;DoubleClick;SelectionChange;ConvertFormulas;DoNotConvertFormulas;DoNotSelect;DoNotSave;DoNotChange;ProtectRows;Formula;FormulaValue;ValidationList;SelectionList" type="String" />
<column name="EVENT_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="EVENT_NAME" property="Validation.ErrorMessage" value="The column requires values of the varchar(50) datatype." type="String" />
<column name="EVENT_NAME" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="EVENT_NAME" property="Validation.ShowError" value="True" type="Boolean" />
<column name="HANDLER_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_SCHEMA" property="Address" value="$H$7" type="String" />
<column name="HANDLER_SCHEMA" property="ColumnWidth" value="26.14" type="Double" />
<column name="HANDLER_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_NAME" property="Address" value="$I$7" type="String" />
<column name="HANDLER_NAME" property="ColumnWidth" value="26.14" type="Double" />
<column name="HANDLER_TYPE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_TYPE" property="Address" value="$J$7" type="String" />
<column name="HANDLER_TYPE" property="ColumnWidth" value="16.29" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Type" value="3" type="Double" />
<column name="HANDLER_TYPE" property="Validation.AlertStyle" value="1" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Operator" value="8" type="Double" />
<column name="HANDLER_TYPE" property="Validation.Formula1" value="TABLE;VIEW;PROCEDURE;FUNCTION;CODE;HTTP;TEXT;MACRO;CMD;VALUES;RANGE;REFRESH;MENUSEPARATOR" type="String" />
<column name="HANDLER_TYPE" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="HANDLER_TYPE" property="Validation.ErrorMessage" value="The column requires values of the varchar(64) datatype." type="String" />
<column name="HANDLER_TYPE" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="HANDLER_TYPE" property="Validation.ShowError" value="True" type="Boolean" />
<column name="HANDLER_CODE" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="HANDLER_CODE" property="Address" value="$K$7" type="String" />
<column name="HANDLER_CODE" property="ColumnWidth" value="70.71" type="Double" />
<column name="TARGET_WORKSHEET" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Address" value="$L$7" type="String" />
<column name="TARGET_WORKSHEET" property="ColumnWidth" value="21.71" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Type" value="6" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.AlertStyle" value="1" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Operator" value="8" type="Double" />
<column name="TARGET_WORKSHEET" property="Validation.Formula1" value="256" type="String" />
<column name="TARGET_WORKSHEET" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="TARGET_WORKSHEET" property="Validation.ErrorMessage" value="The column requires values of the varchar(256) datatype." type="String" />
<column name="TARGET_WORKSHEET" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="TARGET_WORKSHEET" property="Validation.ShowError" value="True" type="Boolean" />
<column name="MENU_ORDER" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="MENU_ORDER" property="Address" value="$M$7" type="String" />
<column name="MENU_ORDER" property="ColumnWidth" value="15.43" type="Double" />
<column name="MENU_ORDER" property="Validation.Type" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.AlertStyle" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.Operator" value="1" type="Double" />
<column name="MENU_ORDER" property="Validation.Formula1" value="-32768" type="String" />
<column name="MENU_ORDER" property="Validation.Formula2" value="32767" type="String" />
<column name="MENU_ORDER" property="Validation.IgnoreBlank" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.InCellDropdown" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.ErrorTitle" value="Datatype Control" type="String" />
<column name="MENU_ORDER" property="Validation.ErrorMessage" value="The column requires values of the smallint datatype." type="String" />
<column name="MENU_ORDER" property="Validation.ShowInput" value="True" type="Boolean" />
<column name="MENU_ORDER" property="Validation.ShowError" value="True" type="Boolean" />
<column name="EDIT_PARAMETERS" property="EntireColumn.Hidden" value="False" type="Boolean" />
<column name="EDIT_PARAMETERS" property="Address" value="$N$7" type="String" />
<column name="EDIT_PARAMETERS" property="ColumnWidth" value="19.57" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).AppliesTo.Address" value="$D$7:$D$12" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Type" value="2" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Priority" value="1" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Formula1" value="=ISBLANK(D7)" type="String" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.Color" value="65535" type="Double" />
<column name="TABLE_SCHEMA" property="FormatConditions(1).Interior.PatternThemeColor" value="-1" type="Double" />
<column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" />
<column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" />
<column name="" property="ActiveWindow.Split" value="True" type="Boolean" />
<column name="" property="ActiveWindow.SplitRow" value="0" type="Double" />
<column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" />
<column name="" property="PageSetup.Orientation" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" />
<column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" />
</columnFormats>
</table>
');
