-- =============================================
-- SaveToDB Sample 13 for Snowflake - Tests
-- Version 10.8, January 9, 2023
--
-- Copyright 2021-2023 Gartle LLC
--
-- License: MIT
-- =============================================

CREATE SCHEMA S13;

CREATE TABLE S13.DATATYPES (
      ID int IDENTITY(1,1) NOT NULL
    , "ARRAY" ARRAY
    , "BINARY" BINARY
    , "BINARY8" BINARY(8)
    , "BINARY16" BINARY(16)
    , "BOOLEAN" BOOLEAN
    , "CHAR" CHAR
    , "DATE" DATE
    , "FLOAT" FLOAT
    , "GEOGRAPHY" GEOGRAPHY
    , "NUMBER" NUMBER
    , "NUMBER1" NUMBER(1)
    , "NUMBER2" NUMBER(2)
    , "NUMBER3" NUMBER(3)
    , "NUMBER4" NUMBER(4)
    , "NUMBER5" NUMBER(5)
    , "NUMBER9" NUMBER(9)
    , "NUMBER10" NUMBER(10)
    , "NUMBER18" NUMBER(18)
    , "NUMBER19" NUMBER(19)
    , "NUMBER104" NUMBER(10,4)
    , "NUMBER152" NUMBER(15,2)
    , "NUMBER194" NUMBER(19,4)
    , "OBJECT" OBJECT
    , "TIME" TIME
    , "TIME0" TIME(0)
    , "TIME3" TIME(3)
    , "TIME7" TIME(7)
    , "TIMESTAMP_LTZ" TIMESTAMP_LTZ
    , "TIMESTAMP_LTZ0" TIMESTAMP_LTZ(0)
    , "TIMESTAMP_LTZ3" TIMESTAMP_LTZ(3)
    , "TIMESTAMP_LTZ7" TIMESTAMP_LTZ(7)
    , "TIMESTAMP_NTZ" TIMESTAMP_NTZ
    , "TIMESTAMP_NTZ0" TIMESTAMP_NTZ(0)
    , "TIMESTAMP_NTZ3" TIMESTAMP_NTZ(3)
    , "TIMESTAMP_NTZ7" TIMESTAMP_NTZ(7)
    , "TIMESTAMP_TZ" TIMESTAMP_TZ
    , "TIMESTAMP_TZ0" TIMESTAMP_TZ(0)
    , "TIMESTAMP_TZ3" TIMESTAMP_TZ(3)
    , "TIMESTAMP_TZ7" TIMESTAMP_TZ(7)
    , "VARCHAR" VARCHAR
    , "VARCHAR255" VARCHAR(255)
    , "VARIANT" VARIANT
    , CONSTRAINT PK_DATATYPES PRIMARY KEY (ID)
);

CREATE OR REPLACE FUNCTION S13.USP_DATATYPES()
    RETURNS TABLE (
    ID int
    , "ARRAY" ARRAY
    , "BINARY" BINARY
    , "BINARY8" BINARY(8)
    , "BINARY16" BINARY(16)
    , "BOOLEAN" BOOLEAN
    , "CHAR" CHAR
    , "DATE" DATE
    , "FLOAT" FLOAT
    , "GEOGRAPHY" GEOGRAPHY
    , "NUMBER" NUMBER
    , "NUMBER1" NUMBER(1)
    , "NUMBER2" NUMBER(2)
    , "NUMBER3" NUMBER(3)
    , "NUMBER4" NUMBER(4)
    , "NUMBER5" NUMBER(5)
    , "NUMBER9" NUMBER(9)
    , "NUMBER10" NUMBER(10)
    , "NUMBER18" NUMBER(18)
    , "NUMBER19" NUMBER(19)
    , "NUMBER104" NUMBER(10,4)
    , "NUMBER152" NUMBER(15,2)
    , "NUMBER194" NUMBER(19,4)
    , "OBJECT" OBJECT
    , "TIME" TIME
    , "TIME0" TIME(0)
    , "TIME3" TIME(3)
    , "TIME7" TIME(7)
    , "TIMESTAMP_LTZ" TIMESTAMP_LTZ
    , "TIMESTAMP_LTZ0" TIMESTAMP_LTZ(0)
    , "TIMESTAMP_LTZ3" TIMESTAMP_LTZ(3)
    , "TIMESTAMP_LTZ7" TIMESTAMP_LTZ(7)
    , "TIMESTAMP_NTZ" TIMESTAMP_NTZ
    , "TIMESTAMP_NTZ0" TIMESTAMP_NTZ(0)
    , "TIMESTAMP_NTZ3" TIMESTAMP_NTZ(3)
    , "TIMESTAMP_NTZ7" TIMESTAMP_NTZ(7)
    , "TIMESTAMP_TZ" TIMESTAMP_TZ
    , "TIMESTAMP_TZ0" TIMESTAMP_TZ(0)
    , "TIMESTAMP_TZ3" TIMESTAMP_TZ(3)
    , "TIMESTAMP_TZ7" TIMESTAMP_TZ(7)
    , "VARCHAR" VARCHAR
    , "VARCHAR255" VARCHAR(255)
    , "VARIANT" VARIANT
    )
AS
'SELECT
    t.ID
    , t."ARRAY"
    , t."BINARY"
    , t."BINARY8"
    , t."BINARY16"
    , t."BOOLEAN"
    , t."CHAR"
    , t."DATE"
    , t."FLOAT"
    , t."GEOGRAPHY"
    , t."NUMBER"
    , t."NUMBER1"
    , t."NUMBER2"
    , t."NUMBER3"
    , t."NUMBER4"
    , t."NUMBER5"
    , t."NUMBER9"
    , t."NUMBER10"
    , t."NUMBER18"
    , t."NUMBER19"
    , t."NUMBER104"
    , t."NUMBER152"
    , t."NUMBER194"
    , t."OBJECT"
    , t."TIME"
    , t."TIME0"
    , t."TIME3"
    , t."TIME7"
    , t."TIMESTAMP_LTZ"
    , t."TIMESTAMP_LTZ0"
    , t."TIMESTAMP_LTZ3"
    , t."TIMESTAMP_LTZ7"
    , t."TIMESTAMP_NTZ"
    , t."TIMESTAMP_NTZ0"
    , t."TIMESTAMP_NTZ3"
    , t."TIMESTAMP_NTZ7"
    , t."TIMESTAMP_TZ"
    , t."TIMESTAMP_TZ0"
    , t."TIMESTAMP_TZ3"
    , t."TIMESTAMP_TZ7"
    , t."VARCHAR"
    , t."VARCHAR255"
    , t."VARIANT"
FROM
    S13.DATATYPES t';

CREATE OR REPLACE FUNCTION S13.USP_ODBC_DATATYPES()
    RETURNS TABLE (
    ID int
    , "ARRAY" VARCHAR
    , "BINARY" VARCHAR
    , "BINARY8" VARCHAR
    , "BINARY16" VARCHAR
    , "BOOLEAN" BOOLEAN
    , "CHAR" CHAR
    , "DATE" DATE
    , "FLOAT" FLOAT
    , "GEOGRAPHY" VARCHAR
    , "NUMBER" VARCHAR
    , "NUMBER1" NUMBER(1)
    , "NUMBER2" NUMBER(2)
    , "NUMBER3" NUMBER(3)
    , "NUMBER4" NUMBER(4)
    , "NUMBER5" NUMBER(5)
    , "NUMBER9" NUMBER(9)
    , "NUMBER10" NUMBER(10)
    , "NUMBER18" VARCHAR
    , "NUMBER19" VARCHAR
    , "NUMBER104" NUMBER(10,4)
    , "NUMBER152" NUMBER(15,2)
    , "NUMBER194" VARCHAR
    , "OBJECT" VARCHAR
    , "TIME" VARCHAR
    , "TIME0" TIME(0)
    , "TIME3" VARCHAR
    , "TIME7" VARCHAR
    , "TIMESTAMP_LTZ" VARCHAR
    , "TIMESTAMP_LTZ0" TIMESTAMP_LTZ(0)
    , "TIMESTAMP_LTZ3" VARCHAR
    , "TIMESTAMP_LTZ7" VARCHAR
    , "TIMESTAMP_NTZ" VARCHAR
    , "TIMESTAMP_NTZ0" TIMESTAMP_NTZ(0)
    , "TIMESTAMP_NTZ3" VARCHAR
    , "TIMESTAMP_NTZ7" VARCHAR
    , "TIMESTAMP_TZ" VARCHAR
    , "TIMESTAMP_TZ0" VARCHAR
    , "TIMESTAMP_TZ3" VARCHAR
    , "TIMESTAMP_TZ7" VARCHAR
    , "VARCHAR" VARCHAR
    , "VARCHAR255" VARCHAR(255)
    , "VARIANT" VARCHAR
    )
AS
'SELECT
    t.ID
    , TO_VARCHAR(t."ARRAY") AS "ARRAY"
    , TO_VARCHAR(t."BINARY", ''HEX'') AS "BINARY"
    , TO_VARCHAR(t."BINARY8", ''HEX'') AS "BINARY8"
    , TO_VARCHAR(t."BINARY16", ''HEX'') AS "BINARY16"
    , t."BOOLEAN"
    , t."CHAR"
    , t."DATE"
    , t."FLOAT"
    , ST_ASTEXT(t."GEOGRAPHY") AS "GEOGRAPHY"
    , TO_VARCHAR(t."NUMBER") AS "NUMBER"
    , t."NUMBER1"
    , t."NUMBER2"
    , t."NUMBER3"
    , t."NUMBER4"
    , t."NUMBER5"
    , t."NUMBER9"
    , t."NUMBER10"
    , TO_VARCHAR(t."NUMBER18") AS "NUMBER18"
    , TO_VARCHAR(t."NUMBER19") AS "NUMBER19"
    , t."NUMBER104"
    , t."NUMBER152"
    , TO_VARCHAR(t."NUMBER194") AS "NUMBER194"
    , TO_VARCHAR("OBJECT") AS "OBJECT"
    , TO_VARCHAR(t."TIME", ''HH24:MI:SS.FF7'') AS "TIME"
    , t."TIME0"
    , TO_VARCHAR(t."TIME3", ''HH24:MI:SS.FF3'') AS "TIME3"
    , TO_VARCHAR(t."TIME7", ''HH24:MI:SS.FF7'') AS "TIME7"
    , TO_VARCHAR(t."TIMESTAMP_LTZ", ''YYYY-MM-DD HH24:MI:SS.FF7'') AS "TIMESTAMP_LTZ"
    , t."TIMESTAMP_LTZ0"
    , TO_VARCHAR("TIMESTAMP_LTZ3", ''YYYY-MM-DD HH24:MI:SS.FF3'') AS "TIMESTAMP_LTZ3"
    , TO_VARCHAR("TIMESTAMP_LTZ7", ''YYYY-MM-DD HH24:MI:SS.FF7'') AS "TIMESTAMP_LTZ7"
    , TO_VARCHAR(t."TIMESTAMP_NTZ", ''YYYY-MM-DD HH24:MI:SS.FF7'') AS "TIMESTAMP_NTZ"
    , t."TIMESTAMP_NTZ0"
    , TO_VARCHAR(t."TIMESTAMP_NTZ3", ''YYYY-MM-DD HH24:MI:SS.FF3'') AS "TIMESTAMP_NTZ3"
    , TO_VARCHAR(t."TIMESTAMP_NTZ7", ''YYYY-MM-DD HH24:MI:SS.FF7'') AS "TIMESTAMP_NTZ7"
    , TO_VARCHAR(t."TIMESTAMP_TZ", ''YYYY-MM-DD HH24:MI:SS.FF7 TZH:TZM'') AS "TIMESTAMP_TZ"
    , TO_VARCHAR(t."TIMESTAMP_TZ0", ''YYYY-MM-DD HH24:MI:SS TZH:TZM'') AS "TIMESTAMP_TZ0"
    , TO_VARCHAR(t."TIMESTAMP_TZ3", ''YYYY-MM-DD HH24:MI:SS.FF3 TZH:TZM'') AS "TIMESTAMP_TZ3"
    , TO_VARCHAR(t."TIMESTAMP_TZ7", ''YYYY-MM-DD HH24:MI:SS.FF7 TZH:TZM'') AS "TIMESTAMP_TZ7"
    , t."VARCHAR"
    , t."VARCHAR255"
    , TO_VARCHAR(t."VARIANT") AS "VARIANT"
FROM
    S13.DATATYPES t';

CREATE OR REPLACE VIEW S13.VIEW_DATATYPE_COLUMNS
AS
SELECT
    c.TABLE_SCHEMA
    , c.TABLE_NAME
    , c.COLUMN_NAME
    , c.ORDINAL_POSITION
    , NULL AS IS_PRIMARY_KEY
    , c.IS_NULLABLE
    , c.IS_IDENTITY
    , 'NO' AS IS_COMPUTED
    , c.COLUMN_DEFAULT
    , c.DATA_TYPE
    , c.CHARACTER_MAXIMUM_LENGTH AS MAX_LENGTH
    , COALESCE(c.NUMERIC_PRECISION, c.DATETIME_PRECISION) AS PRECISION
    , c.NUMERIC_SCALE AS SCALE
FROM
    INFORMATION_SCHEMA.COLUMNS c
WHERE
    c.TABLE_SCHEMA = 'S13' AND c.TABLE_NAME = 'DATATYPES'
ORDER BY
    c.TABLE_SCHEMA
    , c.TABLE_NAME
    , c.ORDINAL_POSITION;

CREATE OR REPLACE VIEW S13.VIEW_DATATYPE_PARAMETERS
AS
SELECT
    f.FUNCTION_SCHEMA
    , f.FUNCTION_NAME
    , f.ARGUMENT_SIGNATURE
    , f.DATA_TYPE
    , f.FUNCTION_LANGUAGE
    , f.FUNCTION_DEFINITION
FROM
    INFORMATION_SCHEMA.FUNCTIONS f
WHERE
    NOT f.FUNCTION_SCHEMA IN ('INFORMATION_SCHEMA')
    AND f.DATA_TYPE ILIKE 'TABLE%'
    AND f.FUNCTION_SCHEMA = 'S13'
UNION ALL
SELECT
    f.PROCEDURE_SCHEMA
    , f.PROCEDURE_NAME
    , f.ARGUMENT_SIGNATURE
    , f.DATA_TYPE
    , f.PROCEDURE_LANGUAGE
    , f.PROCEDURE_DEFINITION
FROM
    INFORMATION_SCHEMA.PROCEDURES f
WHERE
    NOT f.PROCEDURE_SCHEMA IN ('INFORMATION_SCHEMA')
    AND f.PROCEDURE_SCHEMA = 'S13';

-- print Application installed
