-- =============================================
-- SaveToDB Sample 01 for Snowflake - Basic Features
-- Version 10.8, January 9, 2023
--
-- Copyright 2018-2023 Gartle LLC
--
-- License: MIT
-- =============================================

CREATE SCHEMA S01;

CREATE TABLE S01.CASHBOOK (
      ID int IDENTITY(1,1) NOT NULL
    , DATE date NULL
    , ACCOUNT varchar(50)
    , ITEM varchar(50)
    , COMPANY varchar(50)
    , DEBIT number(15,2) NULL
    , CREDIT number(15,2) NULL
    , CONSTRAINT PK_CASHBOOK_S01 PRIMARY KEY (ID)
);

CREATE TABLE S01.FORMATS (
      ID int IDENTITY(1,1) NOT NULL
    , TABLE_SCHEMA varchar(128) NOT NULL
    , TABLE_NAME varchar(128) NOT NULL
    , TABLE_EXCEL_FORMAT_XML string NULL
    , CONSTRAINT PK_FORMATS_S01 PRIMARY KEY (ID)
    , CONSTRAINT IX_FORMATS_S01 UNIQUE (TABLE_NAME, TABLE_SCHEMA)
);

CREATE TABLE S01.WORKBOOKS (
      ID int IDENTITY(1,1) NOT NULL
    , NAME varchar(128) NOT NULL
    , TEMPLATE varchar(255) NULL
    , DEFINITION string NOT NULL
    , TABLE_SCHEMA varchar(128) NULL
    , CONSTRAINT PK_WORKBOOKS_S01 PRIMARY KEY (ID)
    , CONSTRAINT IX_WORKBOOKS_S01 UNIQUE (NAME)
);

CREATE OR REPLACE VIEW S01.VIEW_CASHBOOK
AS

SELECT
    *
FROM
    S01.CASHBOOK t;

CREATE OR REPLACE FUNCTION S01.USP_CASHBOOK (
    ACCOUNT varchar
    , ITEM varchar
    , COMPANY varchar
)
RETURNS TABLE (
    ID int,
    DATE date,
    ACCOUNT varchar(50),
    ITEM varchar(50),
    COMPANY varchar(50),
    DEBIT number(15,2),
    CREDIT number(15,2)
)
AS
'SELECT
    t.ID
    , t.DATE
    , t.ACCOUNT
    , t.ITEM
    , t.COMPANY
    , t.DEBIT
    , t.CREDIT
FROM
    S01.CASHBOOK t
WHERE
    COALESCE(t.ACCOUNT, '''') = COALESCE(ACCOUNT, t.ACCOUNT, '''')
    AND COALESCE(t.ITEM, '''') = COALESCE(ITEM, t.ITEM, '''')
    AND COALESCE(t.COMPANY, '''') = COALESCE(COMPANY, t.COMPANY, '''')';

INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (1,  '2023-01-10', 'Bank', 'Revenue', 'Customer C1', 200000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (2,  '2023-01-10', 'Bank', 'Expenses', 'Supplier S1', NULL, 50000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (3,  '2023-01-31', 'Bank', 'Payroll', NULL, NULL, 85000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (4,  '2023-01-31', 'Bank', 'Taxes', 'Individual Income Tax', NULL, 15000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (5,  '2023-01-31', 'Bank', 'Taxes', 'Payroll Taxes', NULL, 15000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (6,  '2023-02-10', 'Bank', 'Revenue', 'Customer C1', 300000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (7,  '2023-02-10', 'Bank', 'Revenue', 'Customer C2', 100000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (8,  '2023-02-10', 'Bank', 'Expenses', 'Supplier S1', NULL, 100000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (9,  '2023-02-10', 'Bank', 'Expenses', 'Supplier S2', NULL, 50000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (10, '2023-02-28', 'Bank', 'Payroll', NULL, NULL, 85000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (11, '2023-02-28', 'Bank', 'Taxes', 'Individual Income Tax', NULL, 15000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (12, '2023-02-28', 'Bank', 'Taxes', 'Payroll Taxes', NULL, 15000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (13, '2023-03-10', 'Bank', 'Revenue', 'Customer C1', 300000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (14, '2023-03-10', 'Bank', 'Revenue', 'Customer C2', 200000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (15, '2023-03-10', 'Bank', 'Revenue', 'Customer C3', 100000, NULL);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (16, '2023-03-15', 'Bank', 'Taxes', 'Corporate Income Tax', NULL, 100000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (17, '2023-03-31', 'Bank', 'Payroll', NULL, NULL, 170000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (18, '2023-03-31', 'Bank', 'Taxes', 'Individual Income Tax', NULL, 30000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (19, '2023-03-31', 'Bank', 'Taxes', 'Payroll Taxes', NULL, 30000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (20, '2023-03-31', 'Bank', 'Expenses', 'Supplier S1', NULL, 100000);
INSERT INTO S01.CASHBOOK (ID, DATE, ACCOUNT, ITEM, COMPANY, DEBIT, CREDIT) VALUES (21, '2023-03-31', 'Bank', 'Expenses', 'Supplier S2', NULL, 50000);

-- print Application installed
