-- =============================================
-- SaveToDB Framework for Snowflake
-- Version 8.19, February 5, 2019
--
-- This script upgrades SaveToDB Framework 8.15 to SaveToDB Framework 8.19
--
-- Copyright 2018-2019 Gartle Technology Corporation
-- =============================================

ALTER TABLE XLS.WORKBOOKS ADD COLUMN TABLE_SCHEMA varchar(128) NULL;

UPDATE XLS.HANDLERS SET HANDLER_CODE = 'Actions, Change, ContextMenu, DoubleClick, SelectionChange, ConvertFormulas, DoNotConvertFormulas, DoNotSelect, DoNotSave, DoNotChange, DoNotAddValidation, DoNotAddChangeHandler, ProtectRows, Formula, FormulaValue, ParameterValues, ValidationList, SelectionList, SyncParameter, DefaultListObject, ManyToMany, DoNotAddManyToMany, AddStateColumn, KeepFormulas, DoNotKeepFormulas, UpdateEntireRow, UpdateChangedCellsOnly' WHERE TABLE_SCHEMA = 'XLS' AND TABLE_NAME = 'handlers' AND COLUMN_NAME = 'EVENT_NAME' AND EVENT_NAME = 'ValidationList';

INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'OBJECTS',      NULL, 'Actions', 'XLS', 'SaveToDB Online Help', 'HTTP', 'https://www.savetodb.com/savetodb/configuring-query-list.htm',     NULL, 11, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'HANDLERS',     NULL, 'Actions', 'XLS', 'SaveToDB Online Help', 'HTTP', 'https://www.savetodb.com/savetodb/configuring-event-handlers.htm', NULL, 11, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'TRANSLATIONS', NULL, 'Actions', 'XLS', 'SaveToDB Online Help', 'HTTP', 'https://www.savetodb.com/savetodb/configuring-translation.htm',    NULL, 11, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'FORMATS',      NULL, 'Actions', 'XLS', 'SaveToDB Online Help', 'HTTP', 'https://www.savetodb.com/savetodb/configuring-table-formats.htm',  NULL, 11, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'WORKBOOKS',    NULL, 'Actions', 'XLS', 'SaveToDB Online Help', 'HTTP', 'https://www.savetodb.com/savetodb/configuring-workbooks.htm',      NULL, 11, NULL);

INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'FORMATS',      NULL, 'Actions', 'XLS', 'SaveToDB Framework Online Help', 'HTTP', 'https://www.savetodb.com/help/savetodb-framework-tables.htm#xls.formats', NULL, 12, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'HANDLERS',     NULL, 'Actions', 'XLS', 'SaveToDB Framework Online Help', 'HTTP', 'https://www.savetodb.com/help/savetodb-framework-tables.htm#xls.handlers', NULL, 12, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'OBJECTS',      NULL, 'Actions', 'XLS', 'SaveToDB Framework Online Help', 'HTTP', 'https://www.savetodb.com/help/savetodb-framework-tables.htm#xls.objects', NULL, 12, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'TRANSLATIONS', NULL, 'Actions', 'XLS', 'SaveToDB Framework Online Help', 'HTTP', 'https://www.savetodb.com/help/savetodb-framework-tables.htm#xls.translations', NULL, 12, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('XLS', 'WORKBOOKS',    NULL, 'Actions', 'XLS', 'SaveToDB Framework Online Help', 'HTTP', 'https://www.savetodb.com/help/savetodb-framework-tables.htm#xls.workbooks', NULL, 12, NULL);

INSERT INTO XLS.FORMATS (TABLE_SCHEMA, TABLE_NAME, TABLE_EXCEL_FORMAT_XML) VALUES ('XLS', 'OBJECTS', '<table name="XLS.OBJECTS"><columnFormats><column name="" property="ListObjectName" value="objects" type="String" /><column name="" property="ShowTotals" value="False" type="Boolean" /><column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" /><column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" /><column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" /><column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" /><column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" /><column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="_RowNum" property="Address" value="$B$4" type="String" /><column name="_RowNum" property="NumberFormat" value="General" type="String" /><column name="_RowNum" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="ID" property="Address" value="$C$4" type="String" /><column name="ID" property="NumberFormat" value="General" type="String" /><column name="ID" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="Validation.Type" value="1" type="Double" /><column name="ID" property="Validation.Operator" value="1" type="Double" /><column name="ID" property="Validation.Formula1" value="-2147483648" type="String" /><column name="ID" property="Validation.Formula2" value="2147483647" type="String" /><column name="ID" property="Validation.AlertStyle" value="1" type="Double" /><column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="ID" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="ID" property="Validation.ShowInput" value="True" type="Boolean" /><column name="ID" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_SCHEMA" property="Address" value="$D$4" type="String" /><column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" /><column name="TABLE_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="TABLE_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Type" value="6" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_SCHEMA" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_SCHEMA" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_SCHEMA" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_SCHEMA" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_NAME" property="Address" value="$E$4" type="String" /><column name="TABLE_NAME" property="ColumnWidth" value="20.71" type="Double" /><column name="TABLE_NAME" property="NumberFormat" value="General" type="String" /><column name="TABLE_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_NAME" property="Validation.Type" value="6" type="Double" /><column name="TABLE_NAME" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_NAME" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_TYPE" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_TYPE" property="Address" value="$F$4" type="String" /><column name="TABLE_TYPE" property="ColumnWidth" value="13.14" type="Double" /><column name="TABLE_TYPE" property="NumberFormat" value="General" type="String" /><column name="TABLE_TYPE" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_TYPE" property="Validation.Type" value="3" type="Double" /><column name="TABLE_TYPE" property="Validation.Operator" value="1" type="Double" /><column name="TABLE_TYPE" property="Validation.Formula1" value="TABLE; VIEW; PROCEDURE; CODE; HTTP; TEXT; HIDDEN" type="String" /><column name="TABLE_TYPE" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_TYPE" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_TYPE" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_TYPE" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_TYPE" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_CODE" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_CODE" property="Address" value="$G$4" type="String" /><column name="TABLE_CODE" property="ColumnWidth" value="13.71" type="Double" /><column name="TABLE_CODE" property="NumberFormat" value="General" type="String" /><column name="TABLE_CODE" property="VerticalAlignment" value="-4160" type="Double" /><column name="INSERT_OBJECT" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="INSERT_OBJECT" property="Address" value="$H$4" type="String" /><column name="INSERT_OBJECT" property="ColumnWidth" value="27.86" type="Double" /><column name="INSERT_OBJECT" property="NumberFormat" value="General" type="String" /><column name="INSERT_OBJECT" property="VerticalAlignment" value="-4160" type="Double" /><column name="UPDATE_OBJECT" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="UPDATE_OBJECT" property="Address" value="$I$4" type="String" /><column name="UPDATE_OBJECT" property="ColumnWidth" value="27.86" type="Double" /><column name="UPDATE_OBJECT" property="NumberFormat" value="General" type="String" /><column name="UPDATE_OBJECT" property="VerticalAlignment" value="-4160" type="Double" /><column name="DELETE_OBJECT" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="DELETE_OBJECT" property="Address" value="$J$4" type="String" /><column name="DELETE_OBJECT" property="ColumnWidth" value="27.86" type="Double" /><column name="DELETE_OBJECT" property="NumberFormat" value="General" type="String" /><column name="DELETE_OBJECT" property="VerticalAlignment" value="-4160" type="Double" /><column name="SortFields(1)" property="KeyfieldName" value="TABLE_SCHEMA" type="String" /><column name="SortFields(1)" property="SortOn" value="0" type="Double" /><column name="SortFields(1)" property="Order" value="1" type="Double" /><column name="SortFields(1)" property="DataOption" value="0" type="Double" /><column name="SortFields(2)" property="KeyfieldName" value="TABLE_NAME" type="String" /><column name="SortFields(2)" property="SortOn" value="0" type="Double" /><column name="SortFields(2)" property="Order" value="1" type="Double" /><column name="SortFields(2)" property="DataOption" value="0" type="Double" /><column name="" property="Tab.Color" value="10498160" type="Double" /><column name="" property="Tab.Color" value="10498160" type="Double" /><column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" /><column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" /><column name="" property="ActiveWindow.Split" value="True" type="Boolean" /><column name="" property="ActiveWindow.SplitRow" value="0" type="Double" /><column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" /><column name="" property="PageSetup.Orientation" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" /></columnFormats></table>');
INSERT INTO XLS.FORMATS (TABLE_SCHEMA, TABLE_NAME, TABLE_EXCEL_FORMAT_XML) VALUES ('XLS', 'HANDLERS', '<table name="XLS.HANDLERS"><columnFormats><column name="" property="ListObjectName" value="handlers" type="String" /><column name="" property="ShowTotals" value="False" type="Boolean" /><column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" /><column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" /><column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" /><column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" /><column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" /><column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="_RowNum" property="Address" value="$B$4" type="String" /><column name="_RowNum" property="NumberFormat" value="General" type="String" /><column name="_RowNum" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="ID" property="Address" value="$C$4" type="String" /><column name="ID" property="NumberFormat" value="General" type="String" /><column name="ID" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="Validation.Type" value="1" type="Double" /><column name="ID" property="Validation.Operator" value="1" type="Double" /><column name="ID" property="Validation.Formula1" value="-2147483648" type="String" /><column name="ID" property="Validation.Formula2" value="2147483647" type="String" /><column name="ID" property="Validation.AlertStyle" value="1" type="Double" /><column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="ID" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="ID" property="Validation.ShowInput" value="True" type="Boolean" /><column name="ID" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_SCHEMA" property="Address" value="$D$4" type="String" /><column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" /><column name="TABLE_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="TABLE_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Type" value="6" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Formula1" value="20" type="String" /><column name="TABLE_SCHEMA" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_SCHEMA" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_SCHEMA" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(20) datatype." type="String" /><column name="TABLE_SCHEMA" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_NAME" property="Address" value="$E$4" type="String" /><column name="TABLE_NAME" property="ColumnWidth" value="14.43" type="Double" /><column name="TABLE_NAME" property="NumberFormat" value="General" type="String" /><column name="TABLE_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_NAME" property="Validation.Type" value="6" type="Double" /><column name="TABLE_NAME" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_NAME" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="COLUMN_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="COLUMN_NAME" property="Address" value="$F$4" type="String" /><column name="COLUMN_NAME" property="ColumnWidth" value="17.43" type="Double" /><column name="COLUMN_NAME" property="NumberFormat" value="General" type="String" /><column name="COLUMN_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="COLUMN_NAME" property="Validation.Type" value="6" type="Double" /><column name="COLUMN_NAME" property="Validation.Operator" value="8" type="Double" /><column name="COLUMN_NAME" property="Validation.Formula1" value="128" type="String" /><column name="COLUMN_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="COLUMN_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="COLUMN_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="COLUMN_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="EVENT_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="EVENT_NAME" property="Address" value="$G$4" type="String" /><column name="EVENT_NAME" property="ColumnWidth" value="21.57" type="Double" /><column name="EVENT_NAME" property="NumberFormat" value="General" type="String" /><column name="EVENT_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="EVENT_NAME" property="Validation.Type" value="3" type="Double" /><column name="EVENT_NAME" property="Validation.Operator" value="1" type="Double" /><column name="EVENT_NAME" property="Validation.Formula1" value="=INDIRECT(&quot;vl_xls_handlers_event_name&quot;)" type="String" /><column name="EVENT_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="EVENT_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="EVENT_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="EVENT_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="EVENT_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="HANDLER_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="HANDLER_SCHEMA" property="Address" value="$H$4" type="String" /><column name="HANDLER_SCHEMA" property="ColumnWidth" value="19.71" type="Double" /><column name="HANDLER_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="HANDLER_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="HANDLER_SCHEMA" property="Validation.Type" value="6" type="Double" /><column name="HANDLER_SCHEMA" property="Validation.Operator" value="8" type="Double" /><column name="HANDLER_SCHEMA" property="Validation.Formula1" value="20" type="String" /><column name="HANDLER_SCHEMA" property="Validation.AlertStyle" value="1" type="Double" /><column name="HANDLER_SCHEMA" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="HANDLER_SCHEMA" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="HANDLER_SCHEMA" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="HANDLER_SCHEMA" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(20) datatype." type="String" /><column name="HANDLER_SCHEMA" property="Validation.ShowInput" value="True" type="Boolean" /><column name="HANDLER_SCHEMA" property="Validation.ShowError" value="True" type="Boolean" /><column name="HANDLER_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="HANDLER_NAME" property="Address" value="$I$4" type="String" /><column name="HANDLER_NAME" property="ColumnWidth" value="31.14" type="Double" /><column name="HANDLER_NAME" property="NumberFormat" value="General" type="String" /><column name="HANDLER_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="HANDLER_NAME" property="Validation.Type" value="6" type="Double" /><column name="HANDLER_NAME" property="Validation.Operator" value="8" type="Double" /><column name="HANDLER_NAME" property="Validation.Formula1" value="128" type="String" /><column name="HANDLER_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="HANDLER_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="HANDLER_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="HANDLER_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="HANDLER_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="HANDLER_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="HANDLER_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="HANDLER_TYPE" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="HANDLER_TYPE" property="Address" value="$J$4" type="String" /><column name="HANDLER_TYPE" property="ColumnWidth" value="16.29" type="Double" /><column name="HANDLER_TYPE" property="NumberFormat" value="General" type="String" /><column name="HANDLER_TYPE" property="VerticalAlignment" value="-4160" type="Double" /><column name="HANDLER_TYPE" property="Validation.Type" value="3" type="Double" /><column name="HANDLER_TYPE" property="Validation.Operator" value="1" type="Double" /><column name="HANDLER_TYPE" property="Validation.Formula1" value="TABLE; VIEW; PROCEDURE; FUNCTION; CODE; HTTP; TEXT; MACRO; CMD; VALUES; RANGE; REFRESH; MENUSEPARATOR; PDF; REPORT; SHOWSHEETS; HIDESHEETS; SELECTSHEET" type="String" /><column name="HANDLER_TYPE" property="Validation.AlertStyle" value="1" type="Double" /><column name="HANDLER_TYPE" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="HANDLER_TYPE" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="HANDLER_TYPE" property="Validation.ShowInput" value="True" type="Boolean" /><column name="HANDLER_TYPE" property="Validation.ShowError" value="True" type="Boolean" /><column name="HANDLER_CODE" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="HANDLER_CODE" property="Address" value="$K$4" type="String" /><column name="HANDLER_CODE" property="ColumnWidth" value="70.71" type="Double" /><column name="HANDLER_CODE" property="NumberFormat" value="General" type="String" /><column name="HANDLER_CODE" property="VerticalAlignment" value="-4160" type="Double" /><column name="TARGET_WORKSHEET" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TARGET_WORKSHEET" property="Address" value="$L$4" type="String" /><column name="TARGET_WORKSHEET" property="ColumnWidth" value="21.71" type="Double" /><column name="TARGET_WORKSHEET" property="NumberFormat" value="General" type="String" /><column name="TARGET_WORKSHEET" property="VerticalAlignment" value="-4160" type="Double" /><column name="TARGET_WORKSHEET" property="Validation.Type" value="6" type="Double" /><column name="TARGET_WORKSHEET" property="Validation.Operator" value="8" type="Double" /><column name="TARGET_WORKSHEET" property="Validation.Formula1" value="128" type="String" /><column name="TARGET_WORKSHEET" property="Validation.AlertStyle" value="1" type="Double" /><column name="TARGET_WORKSHEET" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TARGET_WORKSHEET" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TARGET_WORKSHEET" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TARGET_WORKSHEET" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TARGET_WORKSHEET" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TARGET_WORKSHEET" property="Validation.ShowError" value="True" type="Boolean" /><column name="MENU_ORDER" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="MENU_ORDER" property="Address" value="$M$4" type="String" /><column name="MENU_ORDER" property="ColumnWidth" value="15.43" type="Double" /><column name="MENU_ORDER" property="NumberFormat" value="General" type="String" /><column name="MENU_ORDER" property="VerticalAlignment" value="-4160" type="Double" /><column name="MENU_ORDER" property="Validation.Type" value="1" type="Double" /><column name="MENU_ORDER" property="Validation.Operator" value="1" type="Double" /><column name="MENU_ORDER" property="Validation.Formula1" value="-2147483648" type="String" /><column name="MENU_ORDER" property="Validation.Formula2" value="2147483647" type="String" /><column name="MENU_ORDER" property="Validation.AlertStyle" value="1" type="Double" /><column name="MENU_ORDER" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="MENU_ORDER" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="MENU_ORDER" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="MENU_ORDER" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="MENU_ORDER" property="Validation.ShowInput" value="True" type="Boolean" /><column name="MENU_ORDER" property="Validation.ShowError" value="True" type="Boolean" /><column name="EDIT_PARAMETERS" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="EDIT_PARAMETERS" property="Address" value="$N$4" type="String" /><column name="EDIT_PARAMETERS" property="ColumnWidth" value="19.57" type="Double" /><column name="EDIT_PARAMETERS" property="NumberFormat" value="General" type="String" /><column name="EDIT_PARAMETERS" property="HorizontalAlignment" value="-4108" type="Double" /><column name="EDIT_PARAMETERS" property="VerticalAlignment" value="-4160" type="Double" /><column name="EDIT_PARAMETERS" property="Font.Size" value="10" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).AppliesTo.Address" value="$N$4:$N$18" type="String" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).Type" value="6" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).Priority" value="2" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).ShowIconOnly" value="True" type="Boolean" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconSet.ID" value="8" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(1).Type" value="3" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(1).Operator" value="7" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(2).Type" value="0" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(2).Value" value="0.5" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(2).Operator" value="7" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(3).Type" value="0" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(3).Value" value="1" type="Double" /><column name="EDIT_PARAMETERS" property="FormatConditions(1).IconCriteria(3).Operator" value="7" type="Double" /><column name="SortFields(1)" property="KeyfieldName" value="EVENT_NAME" type="String" /><column name="SortFields(1)" property="SortOn" value="0" type="Double" /><column name="SortFields(1)" property="Order" value="1" type="Double" /><column name="SortFields(1)" property="DataOption" value="0" type="Double" /><column name="SortFields(2)" property="KeyfieldName" value="TABLE_SCHEMA" type="String" /><column name="SortFields(2)" property="SortOn" value="0" type="Double" /><column name="SortFields(2)" property="Order" value="1" type="Double" /><column name="SortFields(2)" property="DataOption" value="0" type="Double" /><column name="SortFields(3)" property="KeyfieldName" value="TABLE_NAME" type="String" /><column name="SortFields(3)" property="SortOn" value="0" type="Double" /><column name="SortFields(3)" property="Order" value="1" type="Double" /><column name="SortFields(3)" property="DataOption" value="0" type="Double" /><column name="SortFields(4)" property="KeyfieldName" value="COLUMN_NAME" type="String" /><column name="SortFields(4)" property="SortOn" value="0" type="Double" /><column name="SortFields(4)" property="Order" value="1" type="Double" /><column name="SortFields(4)" property="DataOption" value="0" type="Double" /><column name="SortFields(5)" property="KeyfieldName" value="MENU_ORDER" type="String" /><column name="SortFields(5)" property="SortOn" value="0" type="Double" /><column name="SortFields(5)" property="Order" value="1" type="Double" /><column name="SortFields(5)" property="DataOption" value="0" type="Double" /><column name="SortFields(6)" property="KeyfieldName" value="HANDLER_SCHEMA" type="String" /><column name="SortFields(6)" property="SortOn" value="0" type="Double" /><column name="SortFields(6)" property="Order" value="1" type="Double" /><column name="SortFields(6)" property="DataOption" value="0" type="Double" /><column name="SortFields(7)" property="KeyfieldName" value="HANDLER_NAME" type="String" /><column name="SortFields(7)" property="SortOn" value="0" type="Double" /><column name="SortFields(7)" property="Order" value="1" type="Double" /><column name="SortFields(7)" property="DataOption" value="0" type="Double" /><column name="" property="Tab.Color" value="5287936" type="Double" /><column name="" property="Tab.Color" value="5287936" type="Double" /><column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" /><column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" /><column name="" property="ActiveWindow.Split" value="True" type="Boolean" /><column name="" property="ActiveWindow.SplitRow" value="0" type="Double" /><column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" /><column name="" property="PageSetup.Orientation" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" /></columnFormats></table>');
INSERT INTO XLS.FORMATS (TABLE_SCHEMA, TABLE_NAME, TABLE_EXCEL_FORMAT_XML) VALUES ('XLS', 'TRANSLATIONS', '<table name="XLS.TRANSLATIONS"><columnFormats><column name="" property="ListObjectName" value="translations" type="String" /><column name="" property="ShowTotals" value="False" type="Boolean" /><column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" /><column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" /><column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" /><column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" /><column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" /><column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="_RowNum" property="Address" value="$B$4" type="String" /><column name="_RowNum" property="NumberFormat" value="General" type="String" /><column name="_RowNum" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="ID" property="Address" value="$C$4" type="String" /><column name="ID" property="NumberFormat" value="General" type="String" /><column name="ID" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="Validation.Type" value="1" type="Double" /><column name="ID" property="Validation.Operator" value="1" type="Double" /><column name="ID" property="Validation.Formula1" value="-2147483648" type="String" /><column name="ID" property="Validation.Formula2" value="2147483647" type="String" /><column name="ID" property="Validation.AlertStyle" value="1" type="Double" /><column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="ID" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="ID" property="Validation.ShowInput" value="True" type="Boolean" /><column name="ID" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_SCHEMA" property="Address" value="$D$4" type="String" /><column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" /><column name="TABLE_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="TABLE_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Type" value="6" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_SCHEMA" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_SCHEMA" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_SCHEMA" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_SCHEMA" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_NAME" property="Address" value="$E$4" type="String" /><column name="TABLE_NAME" property="ColumnWidth" value="14.43" type="Double" /><column name="TABLE_NAME" property="NumberFormat" value="General" type="String" /><column name="TABLE_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_NAME" property="Validation.Type" value="6" type="Double" /><column name="TABLE_NAME" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_NAME" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="COLUMN_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="COLUMN_NAME" property="Address" value="$F$4" type="String" /><column name="COLUMN_NAME" property="ColumnWidth" value="17.43" type="Double" /><column name="COLUMN_NAME" property="NumberFormat" value="General" type="String" /><column name="COLUMN_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="COLUMN_NAME" property="Validation.Type" value="6" type="Double" /><column name="COLUMN_NAME" property="Validation.Operator" value="8" type="Double" /><column name="COLUMN_NAME" property="Validation.Formula1" value="128" type="String" /><column name="COLUMN_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="COLUMN_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="COLUMN_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="COLUMN_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="COLUMN_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="LANGUAGE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="LANGUAGE_NAME" property="Address" value="$G$4" type="String" /><column name="LANGUAGE_NAME" property="ColumnWidth" value="19.57" type="Double" /><column name="LANGUAGE_NAME" property="NumberFormat" value="General" type="String" /><column name="LANGUAGE_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="LANGUAGE_NAME" property="Validation.Type" value="6" type="Double" /><column name="LANGUAGE_NAME" property="Validation.Operator" value="8" type="Double" /><column name="LANGUAGE_NAME" property="Validation.Formula1" value="2" type="String" /><column name="LANGUAGE_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="LANGUAGE_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="LANGUAGE_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="LANGUAGE_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="LANGUAGE_NAME" property="Validation.ErrorMessage" value="The column requires values of the char(2) datatype." type="String" /><column name="LANGUAGE_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="LANGUAGE_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="TRANSLATED_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TRANSLATED_NAME" property="Address" value="$H$4" type="String" /><column name="TRANSLATED_NAME" property="ColumnWidth" value="20.71" type="Double" /><column name="TRANSLATED_NAME" property="NumberFormat" value="General" type="String" /><column name="TRANSLATED_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="TRANSLATED_NAME" property="Validation.Type" value="6" type="Double" /><column name="TRANSLATED_NAME" property="Validation.Operator" value="8" type="Double" /><column name="TRANSLATED_NAME" property="Validation.Formula1" value="128" type="String" /><column name="TRANSLATED_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="TRANSLATED_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TRANSLATED_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TRANSLATED_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TRANSLATED_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TRANSLATED_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TRANSLATED_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="TRANSLATED_DESC" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TRANSLATED_DESC" property="Address" value="$I$4" type="String" /><column name="TRANSLATED_DESC" property="ColumnWidth" value="19.57" type="Double" /><column name="TRANSLATED_DESC" property="NumberFormat" value="General" type="String" /><column name="TRANSLATED_DESC" property="VerticalAlignment" value="-4160" type="Double" /><column name="TRANSLATED_DESC" property="Validation.Type" value="6" type="Double" /><column name="TRANSLATED_DESC" property="Validation.Operator" value="8" type="Double" /><column name="TRANSLATED_DESC" property="Validation.Formula1" value="1024" type="String" /><column name="TRANSLATED_DESC" property="Validation.AlertStyle" value="1" type="Double" /><column name="TRANSLATED_DESC" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TRANSLATED_DESC" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TRANSLATED_DESC" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TRANSLATED_DESC" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(1024) datatype." type="String" /><column name="TRANSLATED_DESC" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TRANSLATED_DESC" property="Validation.ShowError" value="True" type="Boolean" /><column name="TRANSLATED_COMMENT" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TRANSLATED_COMMENT" property="Address" value="$J$4" type="String" /><column name="TRANSLATED_COMMENT" property="ColumnWidth" value="25" type="Double" /><column name="TRANSLATED_COMMENT" property="NumberFormat" value="General" type="String" /><column name="TRANSLATED_COMMENT" property="VerticalAlignment" value="-4160" type="Double" /><column name="TRANSLATED_COMMENT" property="Validation.Type" value="6" type="Double" /><column name="TRANSLATED_COMMENT" property="Validation.Operator" value="8" type="Double" /><column name="TRANSLATED_COMMENT" property="Validation.Formula1" value="2000" type="String" /><column name="TRANSLATED_COMMENT" property="Validation.AlertStyle" value="1" type="Double" /><column name="TRANSLATED_COMMENT" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TRANSLATED_COMMENT" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TRANSLATED_COMMENT" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TRANSLATED_COMMENT" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(2000) datatype." type="String" /><column name="TRANSLATED_COMMENT" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TRANSLATED_COMMENT" property="Validation.ShowError" value="True" type="Boolean" /><column name="SortFields(1)" property="KeyfieldName" value="LANGUAGE_NAME" type="String" /><column name="SortFields(1)" property="SortOn" value="0" type="Double" /><column name="SortFields(1)" property="Order" value="1" type="Double" /><column name="SortFields(1)" property="DataOption" value="0" type="Double" /><column name="SortFields(2)" property="KeyfieldName" value="COLUMN_NAME" type="String" /><column name="SortFields(2)" property="SortOn" value="0" type="Double" /><column name="SortFields(2)" property="Order" value="1" type="Double" /><column name="SortFields(2)" property="DataOption" value="0" type="Double" /><column name="SortFields(3)" property="KeyfieldName" value="TABLE_SCHEMA" type="String" /><column name="SortFields(3)" property="SortOn" value="0" type="Double" /><column name="SortFields(3)" property="Order" value="1" type="Double" /><column name="SortFields(3)" property="DataOption" value="0" type="Double" /><column name="SortFields(4)" property="KeyfieldName" value="TABLE_NAME" type="String" /><column name="SortFields(4)" property="SortOn" value="0" type="Double" /><column name="SortFields(4)" property="Order" value="1" type="Double" /><column name="SortFields(4)" property="DataOption" value="0" type="Double" /><column name="" property="Tab.Color" value="6299648" type="Double" /><column name="" property="Tab.Color" value="6299648" type="Double" /><column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" /><column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" /><column name="" property="ActiveWindow.Split" value="True" type="Boolean" /><column name="" property="ActiveWindow.SplitRow" value="0" type="Double" /><column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" /><column name="" property="PageSetup.Orientation" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" /></columnFormats></table>');
INSERT INTO XLS.FORMATS (TABLE_SCHEMA, TABLE_NAME, TABLE_EXCEL_FORMAT_XML) VALUES ('XLS', 'WORKBOOKS', '<table name="XLS.WORKBOOKS"><columnFormats><column name="" property="ListObjectName" value="workbooks" type="String" /><column name="" property="ShowTotals" value="False" type="Boolean" /><column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" /><column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" /><column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" /><column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" /><column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" /><column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="_RowNum" property="Address" value="$B$4" type="String" /><column name="_RowNum" property="NumberFormat" value="General" type="String" /><column name="_RowNum" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="ID" property="Address" value="$C$4" type="String" /><column name="ID" property="NumberFormat" value="General" type="String" /><column name="ID" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="Validation.Type" value="1" type="Double" /><column name="ID" property="Validation.Operator" value="1" type="Double" /><column name="ID" property="Validation.Formula1" value="-2147483648" type="String" /><column name="ID" property="Validation.Formula2" value="2147483647" type="String" /><column name="ID" property="Validation.AlertStyle" value="1" type="Double" /><column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="ID" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="ID" property="Validation.ShowInput" value="True" type="Boolean" /><column name="ID" property="Validation.ShowError" value="True" type="Boolean" /><column name="NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="NAME" property="Address" value="$D$4" type="String" /><column name="NAME" property="ColumnWidth" value="21.71" type="Double" /><column name="NAME" property="NumberFormat" value="General" type="String" /><column name="NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="NAME" property="Validation.Type" value="6" type="Double" /><column name="NAME" property="Validation.Operator" value="8" type="Double" /><column name="NAME" property="Validation.Formula1" value="128" type="String" /><column name="NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="TEMPLATE" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TEMPLATE" property="Address" value="$E$4" type="String" /><column name="TEMPLATE" property="ColumnWidth" value="23.57" type="Double" /><column name="TEMPLATE" property="NumberFormat" value="General" type="String" /><column name="TEMPLATE" property="VerticalAlignment" value="-4160" type="Double" /><column name="TEMPLATE" property="Validation.Type" value="6" type="Double" /><column name="TEMPLATE" property="Validation.Operator" value="8" type="Double" /><column name="TEMPLATE" property="Validation.Formula1" value="255" type="String" /><column name="TEMPLATE" property="Validation.AlertStyle" value="1" type="Double" /><column name="TEMPLATE" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TEMPLATE" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TEMPLATE" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TEMPLATE" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(255) datatype." type="String" /><column name="TEMPLATE" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TEMPLATE" property="Validation.ShowError" value="True" type="Boolean" /><column name="DEFINITION" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="DEFINITION" property="Address" value="$F$4" type="String" /><column name="DEFINITION" property="ColumnWidth" value="70.71" type="Double" /><column name="DEFINITION" property="NumberFormat" value="General" type="String" /><column name="DEFINITION" property="VerticalAlignment" value="-4160" type="Double" /><column name="DEFINITION" property="WrapText" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_SCHEMA" property="Address" value="$G$4" type="String" /><column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" /><column name="TABLE_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="TABLE_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="SortFields(1)" property="KeyfieldName" value="TABLE_SCHEMA" type="String" /><column name="SortFields(1)" property="SortOn" value="0" type="Double" /><column name="SortFields(1)" property="Order" value="1" type="Double" /><column name="SortFields(1)" property="DataOption" value="0" type="Double" /><column name="SortFields(2)" property="KeyfieldName" value="NAME" type="String" /><column name="SortFields(2)" property="SortOn" value="0" type="Double" /><column name="SortFields(2)" property="Order" value="1" type="Double" /><column name="SortFields(2)" property="DataOption" value="0" type="Double" /><column name="" property="Tab.Color" value="15773696" type="Double" /><column name="" property="Tab.Color" value="15773696" type="Double" /><column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" /><column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" /><column name="" property="ActiveWindow.Split" value="True" type="Boolean" /><column name="" property="ActiveWindow.SplitRow" value="0" type="Double" /><column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" /><column name="" property="PageSetup.Orientation" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" /></columnFormats></table>');
INSERT INTO XLS.FORMATS (TABLE_SCHEMA, TABLE_NAME, TABLE_EXCEL_FORMAT_XML) VALUES ('XLS', 'FORMATS', '<table name="XLS.FORMATS"><columnFormats><column name="" property="ListObjectName" value="handlers" type="String" /><column name="" property="ShowTotals" value="False" type="Boolean" /><column name="" property="TableStyle.Name" value="TableStyleMedium15" type="String" /><column name="" property="ShowTableStyleColumnStripes" value="False" type="Boolean" /><column name="" property="ShowTableStyleFirstColumn" value="False" type="Boolean" /><column name="" property="ShowShowTableStyleLastColumn" value="False" type="Boolean" /><column name="" property="ShowTableStyleRowStripes" value="False" type="Boolean" /><column name="_RowNum" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="_RowNum" property="Address" value="$B$4" type="String" /><column name="_RowNum" property="NumberFormat" value="General" type="String" /><column name="_RowNum" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="EntireColumn.Hidden" value="True" type="Boolean" /><column name="ID" property="Address" value="$C$4" type="String" /><column name="ID" property="NumberFormat" value="General" type="String" /><column name="ID" property="VerticalAlignment" value="-4160" type="Double" /><column name="ID" property="Validation.Type" value="1" type="Double" /><column name="ID" property="Validation.Operator" value="1" type="Double" /><column name="ID" property="Validation.Formula1" value="-2147483648" type="String" /><column name="ID" property="Validation.Formula2" value="2147483647" type="String" /><column name="ID" property="Validation.AlertStyle" value="1" type="Double" /><column name="ID" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="ID" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="ID" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="ID" property="Validation.ErrorMessage" value="The column requires values of the int datatype." type="String" /><column name="ID" property="Validation.ShowInput" value="True" type="Boolean" /><column name="ID" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_SCHEMA" property="Address" value="$D$4" type="String" /><column name="TABLE_SCHEMA" property="ColumnWidth" value="16.57" type="Double" /><column name="TABLE_SCHEMA" property="NumberFormat" value="General" type="String" /><column name="TABLE_SCHEMA" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Type" value="6" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_SCHEMA" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_SCHEMA" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_SCHEMA" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_SCHEMA" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_SCHEMA" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_SCHEMA" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_NAME" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_NAME" property="Address" value="$E$4" type="String" /><column name="TABLE_NAME" property="ColumnWidth" value="14.43" type="Double" /><column name="TABLE_NAME" property="NumberFormat" value="General" type="String" /><column name="TABLE_NAME" property="VerticalAlignment" value="-4160" type="Double" /><column name="TABLE_NAME" property="Validation.Type" value="6" type="Double" /><column name="TABLE_NAME" property="Validation.Operator" value="8" type="Double" /><column name="TABLE_NAME" property="Validation.Formula1" value="128" type="String" /><column name="TABLE_NAME" property="Validation.AlertStyle" value="1" type="Double" /><column name="TABLE_NAME" property="Validation.IgnoreBlank" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.InCellDropdown" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ErrorTitle" value="Datatype Control" type="String" /><column name="TABLE_NAME" property="Validation.ErrorMessage" value="The column requires values of the nvarchar(128) datatype." type="String" /><column name="TABLE_NAME" property="Validation.ShowInput" value="True" type="Boolean" /><column name="TABLE_NAME" property="Validation.ShowError" value="True" type="Boolean" /><column name="TABLE_EXCEL_FORMAT_XML" property="EntireColumn.Hidden" value="False" type="Boolean" /><column name="TABLE_EXCEL_FORMAT_XML" property="Address" value="$F$4" type="String" /><column name="TABLE_EXCEL_FORMAT_XML" property="ColumnWidth" value="70.71" type="Double" /><column name="TABLE_EXCEL_FORMAT_XML" property="NumberFormat" value="General" type="String" /><column name="TABLE_EXCEL_FORMAT_XML" property="VerticalAlignment" value="-4160" type="Double" /><column name="SortFields(1)" property="KeyfieldName" value="TABLE_SCHEMA" type="String" /><column name="SortFields(1)" property="SortOn" value="0" type="Double" /><column name="SortFields(1)" property="Order" value="1" type="Double" /><column name="SortFields(1)" property="DataOption" value="2" type="Double" /><column name="SortFields(2)" property="KeyfieldName" value="TABLE_NAME" type="String" /><column name="SortFields(2)" property="SortOn" value="0" type="Double" /><column name="SortFields(2)" property="Order" value="1" type="Double" /><column name="SortFields(2)" property="DataOption" value="2" type="Double" /><column name="" property="Tab.Color" value="5287936" type="Double" /><column name="" property="Tab.Color" value="5287936" type="Double" /><column name="" property="ActiveWindow.DisplayGridlines" value="False" type="Boolean" /><column name="" property="ActiveWindow.FreezePanes" value="True" type="Boolean" /><column name="" property="ActiveWindow.Split" value="True" type="Boolean" /><column name="" property="ActiveWindow.SplitRow" value="0" type="Double" /><column name="" property="ActiveWindow.SplitColumn" value="-2" type="Double" /><column name="" property="PageSetup.Orientation" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesWide" value="1" type="Double" /><column name="" property="PageSetup.FitToPagesTall" value="1" type="Double" /></columnFormats></table>');

DELETE FROM XLS.WORKBOOKS WHERE NAME = 'savetodb8_configuration.xlsx';

INSERT INTO XLS.WORKBOOKS (NAME, TEMPLATE, DEFINITION, TABLE_SCHEMA) VALUES ('savetodb_configuration.xlsx', NULL, 'objects=XLS.OBJECTS,(Default),False,$B$3,,{"Parameters":{"TABLE_SCHEMA":null,"TABLE_TYPE":null},"ListObjectName":"objects"}
handlers=XLS.HANDLERS,(Default),False,$B$3,,{"Parameters":{"TABLE_SCHEMA":null,"EVENT_NAME":null,"HANDLER_TYPE":null},"ListObjectName":"handlers"}
translations=XLS.TRANSLATIONS,(Default),False,$B$3,,{"Parameters":{"TABLE_SCHEMA":null,"LANGUAGE_NAME":null},"ListObjectName":"translations"}
workbooks=XLS.WORKBOOKS,(Default),False,$B$3,,{"Parameters":{},"ListObjectName":"workbooks"}', 'XLS');
