-- =============================================
-- Application: Sample 06 - Dynamic Lists
-- Version 10.8, January 9, 2023
--
-- Copyright 2018-2023 Gartle LLC
--
-- License: MIT
--
-- Prerequisites: SaveToDB Framework 8.19 or higher
-- =============================================

CREATE SCHEMA S06;

CREATE TABLE S06.COUNTRIES (
      ID INT IDENTITY(1,1) NOT NULL
    , COUNTRY NVARCHAR(100) NOT NULL
    , CONSTRAINT PK_COUNTRIES_S06 PRIMARY KEY (ID)
    , CONSTRAINT IX_COUNTRIES_S06 UNIQUE (COUNTRY)
);

CREATE TABLE S06.STATES (
      CODE CHAR(2) NOT NULL
    , COUNTRY_ID INT NOT NULL
    , STATE NVARCHAR(50) NOT NULL
    , CAPITAL NVARCHAR(50) NULL
    , CONSTRAINT PK_STATES_S06 PRIMARY KEY (CODE)
    , CONSTRAINT IX_STATES_S06 UNIQUE (STATE)
);

ALTER TABLE S06.STATES ADD CONSTRAINT FK_STATES_COUNTRIES_S06 FOREIGN KEY (COUNTRY_ID) REFERENCES S06.COUNTRIES (ID);

CREATE TABLE S06.DATA (
      ID INT IDENTITY(1,1) NOT NULL
    , COUNTRY_ID INT NULL
    , STATE_CODE CHAR(2) NULL
    , PERIOD DATE NULL
    , VALUE FLOAT NULL
    , CONSTRAINT PK_DATA PRIMARY KEY (ID)
);

ALTER TABLE S06.DATA ADD CONSTRAINT FK_DATA_COUNTRIES_S06 FOREIGN KEY (COUNTRY_ID) REFERENCES S06.COUNTRIES (ID);

ALTER TABLE S06.DATA ADD CONSTRAINT FK_DATA_STATES_S06 FOREIGN KEY (STATE_CODE) REFERENCES S06.STATES (CODE);

CREATE OR REPLACE FUNCTION S06.USP_DATA (
    COUNTRY_ID int
)
RETURNS TABLE (
    ID INT
    , STATE_CODE CHAR(2)
    , PERIOD DATE
    , VALUE FLOAT
)
AS
'SELECT
    t.ID
    , t.STATE_CODE
    , t.PERIOD
    , t.VALUE
FROM
    S06.DATA t
WHERE
    t.COUNTRY_ID = COUNTRY_ID';

INSERT INTO S06.COUNTRIES (ID, COUNTRY) VALUES (1, 'USA');
INSERT INTO S06.COUNTRIES (ID, COUNTRY) VALUES (2, 'Canada');

INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('AK', 1, 'Alaska', 'Juneau');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('AL', 1, 'Alabama', 'Montgomery');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('AR', 1, 'Arkansas', 'Little Rock');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('AZ', 1, 'Arizona', 'Phoenix');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('CA', 1, 'California', 'Sacramento');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('CO', 1, 'Colorado', 'Denver');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('CT', 1, 'Connecticut', 'Hartford');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('DE', 1, 'Delaware', 'Dover');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('FL', 1, 'Florida', 'Tallahassee');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('GA', 1, 'Georgia', 'Atlanta');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('HI', 1, 'Hawaii', 'Honolulu');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('IA', 1, 'Iowa', 'Des Moines');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('ID', 1, 'Idaho', 'Boise');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('IL', 1, 'Illinois', 'Springfield');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('IN', 1, 'Indiana', 'Indianapolis');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('KS', 1, 'Kansas', 'Topeka');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('KY', 1, 'Kentucky', 'Frankfort');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('LA', 1, 'Louisiana', 'Baton Rouge');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MA', 1, 'Massachusetts', 'Boston');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MD', 1, 'Maryland', 'Annapolis');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('ME', 1, 'Maine', 'Augusta');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MI', 1, 'Michigan', 'Lansing');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MN', 1, 'Minnesota', 'Saint Paul');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MO', 1, 'Missouri', 'Jefferson City');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MS', 1, 'Mississippi', 'Jackson');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MT', 1, 'Montana', 'Helena');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NC', 1, 'North Carolina', 'Raleigh');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('ND', 1, 'North Dakota', 'Bismarck');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NE', 1, 'Nebraska', 'Lincoln');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NH', 1, 'New Hampshire', 'Concord');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NJ', 1, 'New Jersey', 'Trenton');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NM', 1, 'New Mexico', 'Santa Fe');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NV', 1, 'Nevada', 'Carson City');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NY', 1, 'New York', 'Albany');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('OH', 1, 'Ohio', 'Columbus');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('OK', 1, 'Oklahoma', 'Oklahoma City');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('OR', 1, 'Oregon', 'Salem');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('PA', 1, 'Pennsylvania', 'Harrisburg');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('RI', 1, 'Rhode Island', 'Providence');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('SC', 1, 'South Carolina', 'Columbia');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('SD', 1, 'South Dakota', 'Pierre');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('TN', 1, 'Tennessee', 'Nashville');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('TX', 1, 'Texas', 'Austin');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('UT', 1, 'Utah', 'Salt Lake City');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('VA', 1, 'Virginia', 'Richmond');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('VT', 1, 'Vermont', 'Montpelier');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('WA', 1, 'Washington', 'Olympia');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('WI', 1, 'Wisconsin', 'Madison');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('WV', 1, 'West Virginia', 'Charleston');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('WY', 1, 'Wyoming', 'Cheyenne');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('AB', 2, 'Alberta', 'Edmonton');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('BC', 2, 'British Columbia', 'Victoria');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('MB', 2, 'Manitoba', 'Winnipeg');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NB', 2, 'New Brunswick', 'Fredericton');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NL', 2, 'Newfoundland and Labrador', 'St. John''s');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NS', 2, 'Nova Scotia', 'Halifax');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NT', 2, 'Northwest Territories', 'Yellowknife');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('NU', 2, 'Nunavut', 'Iqaluit');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('ON', 2, 'Ontario', 'Toronto');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('PE', 2, 'Prince Edward Island', 'Charlottetown');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('QC', 2, 'Quebec', 'Quebec City');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('SK', 2, 'Saskatchewan', 'Regina');
INSERT INTO S06.STATES (CODE, COUNTRY_ID, STATE, CAPITAL) VALUES ('YT', 2, 'Yukon', 'Whitehorse');

INSERT INTO S06.DATA (ID, COUNTRY_ID, STATE_CODE, PERIOD, VALUE) VALUES (1, 1, 'AK', '2018-07-01', 100);
INSERT INTO S06.DATA (ID, COUNTRY_ID, STATE_CODE, PERIOD, VALUE) VALUES (2, 2, 'AB', '2018-07-01', 100);

INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('S06', 'DATA', 'COUNTRY_ID', 'ValidationList', 'S06', 'COUNTRIES', 'TABLE', 'ID,COUNTRY', '', NULL, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('S06', 'DATA', 'STATE_CODE', 'ValidationList', 'S06', 'STATES',    'TABLE', 'CODE,STATE,COUNTRY_ID', NULL, NULL, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('S06', 'USP_DATA', 'COUNTRY_ID', 'ParameterValues', 'S06', 'COUNTRIES', 'TABLE', 'ID,COUNTRY', NULL, NULL, NULL);
INSERT INTO XLS.HANDLERS (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, EVENT_NAME, HANDLER_SCHEMA, HANDLER_NAME, HANDLER_TYPE, HANDLER_CODE, TARGET_WORKSHEET, MENU_ORDER, EDIT_PARAMETERS) VALUES ('S06', 'USP_DATA', 'STATE_CODE', 'ValidationList', 'S06', 'STATES', 'TABLE', 'CODE,STATE,@COUNTRY_ID', NULL, NULL, NULL);

INSERT INTO XLS.WORKBOOKS (NAME, TEMPLATE, DEFINITION, TABLE_SCHEMA) VALUES ('Sample 06 - Dynamic Lists.xlsx', 'Sample 06 - Dynamic Lists.xlsx',
'COUNTRIES=S06.COUNTRIES,(Default),False,$B$3,,{"Parameters":{},"ListObjectName":"countries"}
STATES=S06.STATES,(Default),False,$B$3,,{"Parameters":{"country_id":1},"ListObjectName":"states"}
DATA=S06.DATA,(Default),False,$B$3,,{"Parameters":{},"ListObjectName":"data"}
USP_DATA=S06.USP_DATA,(Default),False,$B$3,,{"Parameters":{"COUNTRY_ID":1},"ListObjectName":"usp_data"}
HANDLERS=XLS.HANDLERS,(Default),False,$B$3,,{"Parameters":{"TABLE_SCHEMA":"S06"},"ListObjectName":"handlers"}', 'S06');

-- print Application installed
